/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.splunkhec;

import java.net.UnknownHostException;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.util.HostUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriParams
public class SplunkHECConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(SplunkHECConfiguration.class);
    @UriParam(defaultValue="camel")
    private String index = "camel";
    @UriParam(defaultValue="camel")
    private String sourceType = "camel";
    @UriParam(defaultValue="camel")
    private String source = "camel";
    @UriParam
    private String host;
    @UriParam(defaultValue="/services/collector/event")
    private String splunkEndpoint = "/services/collector/event";
    @UriParam(label="security", secret=true)
    @Metadata(required=true)
    private String token;
    @UriParam(label="security")
    private boolean skipTlsVerify;
    @UriParam(label="security", defaultValue="true")
    private boolean https = true;
    @UriParam
    private boolean bodyOnly;
    @UriParam
    private boolean headersOnly;
    @UriParam
    private Long time;

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getIndex() {
        return this.index;
    }

    public String getHost() {
        if (this.host == null) {
            try {
                this.host = HostUtils.getLocalHostName();
            }
            catch (UnknownHostException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
                this.host = "unknown";
            }
        }
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setSplunkEndpoint(String splunkEndpoint) {
        this.splunkEndpoint = splunkEndpoint;
    }

    public String getSplunkEndpoint() {
        return this.splunkEndpoint;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public boolean isSkipTlsVerify() {
        return this.skipTlsVerify;
    }

    public void setSkipTlsVerify(boolean skipTlsVerify) {
        this.skipTlsVerify = skipTlsVerify;
    }

    public boolean isHttps() {
        return this.https;
    }

    public void setHttps(boolean https) {
        this.https = https;
    }

    public boolean isBodyOnly() {
        return this.bodyOnly;
    }

    public void setBodyOnly(boolean bodyOnly) {
        this.bodyOnly = bodyOnly;
    }

    public boolean isHeadersOnly() {
        return this.headersOnly;
    }

    public void setHeadersOnly(boolean headersOnly) {
        this.headersOnly = headersOnly;
    }

    public Long getTime() {
        return this.time;
    }

    public void setTime(Long time) {
        this.time = time;
    }
}

