/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.splunk.support;

import com.splunk.Args;
import com.splunk.Service;
import com.splunk.TcpInput;
import java.io.IOException;
import java.net.Socket;
import java.util.Optional;
import org.apache.camel.component.splunk.SplunkEndpoint;
import org.apache.camel.component.splunk.support.SplunkDataWriter;

public class TcpDataWriter
extends SplunkDataWriter {
    private int port;
    private Optional<Integer> localPort;
    private String host;

    public TcpDataWriter(SplunkEndpoint endpoint, Args args) {
        super(endpoint, args);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setLocalPort(Optional<Integer> localPort) {
        this.localPort = localPort;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Override
    protected Socket createSocket(Service service) throws IOException {
        int p = this.localPort.orElseGet(() -> this.port);
        TcpInput input = (TcpInput)service.getInputs().get((Object)String.valueOf(p));
        if (input == null) {
            throw new RuntimeException("no input defined for port " + this.port);
        }
        if (input.isDisabled()) {
            throw new RuntimeException(String.format("input on port %d is disabled", this.port));
        }
        return this.getSocket(input, service);
    }

    Socket getSocket(TcpInput tcpInput, Service service) throws IOException {
        if (this.localPort.isPresent() || this.host != null && !this.host.equals(tcpInput.getHost())) {
            String h = this.host == null ? service.getHost() : this.host;
            return new Socket(h, this.port);
        }
        return tcpInput.attach();
    }
}

