/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.batch;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.spring.batch.SpringBatchProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultEndpoint;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.launch.JobLauncher;

@UriEndpoint(firstVersion="2.10.0", scheme="spring-batch", title="Spring Batch", syntax="spring-batch:jobName", remote=false, producerOnly=true, category={Category.WORKFLOW})
public class SpringBatchEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required=true)
    private String jobName;
    @UriParam
    private boolean jobFromHeader;
    @Deprecated
    private String jobLauncherRef;
    @UriParam
    private JobLauncher jobLauncher;
    private JobLauncher defaultResolvedJobLauncher;
    private Map<String, JobLauncher> allResolvedJobLaunchers;
    private Job job;
    @UriParam
    private JobRegistry jobRegistry;

    public SpringBatchEndpoint(String endpointUri, Component component, JobLauncher jobLauncher, JobLauncher defaultResolvedJobLauncher, Map<String, JobLauncher> allResolvedJobLaunchers, String jobName, JobRegistry jobRegistry) {
        super(endpointUri, component);
        this.jobLauncher = jobLauncher;
        this.defaultResolvedJobLauncher = defaultResolvedJobLauncher;
        this.allResolvedJobLaunchers = allResolvedJobLaunchers;
        this.jobName = jobName;
        this.jobRegistry = jobRegistry;
    }

    public Producer createProducer() throws Exception {
        return new SpringBatchProducer(this, this.jobLauncher, this.job, this.jobRegistry);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Not supported");
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (this.jobLauncher == null) {
            this.jobLauncher = this.resolveJobLauncher();
        }
        if (this.job == null && this.jobName != null && !this.jobFromHeader) {
            this.job = this.jobRegistry != null ? this.jobRegistry.getJob(this.jobName) : (Job)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)this.jobName, Job.class);
        }
    }

    private JobLauncher resolveJobLauncher() {
        if (this.jobLauncherRef != null) {
            JobLauncher jobLauncher = (JobLauncher)this.getCamelContext().getRegistry().lookupByNameAndType(this.jobLauncherRef, JobLauncher.class);
            if (jobLauncher == null) {
                throw new IllegalStateException(String.format("No JobLauncher named %s found in the registry.", this.jobLauncherRef));
            }
            return jobLauncher;
        }
        if (this.defaultResolvedJobLauncher != null) {
            return this.defaultResolvedJobLauncher;
        }
        if (this.allResolvedJobLaunchers.size() == 1) {
            return this.allResolvedJobLaunchers.values().iterator().next();
        }
        if (this.allResolvedJobLaunchers.size() > 1) {
            throw new IllegalStateException("Expected single jobLauncher instance. Found: " + this.allResolvedJobLaunchers.size());
        }
        throw new IllegalStateException("Cannot find Spring Batch JobLauncher.");
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    @Deprecated
    public String getJobLauncherRef() {
        return this.jobLauncherRef;
    }

    @Deprecated
    public void setJobLauncherRef(String jobLauncherRef) {
        this.jobLauncherRef = jobLauncherRef;
    }

    public JobLauncher getJobLauncher() {
        return this.jobLauncher;
    }

    public void setJobLauncher(JobLauncher jobLauncher) {
        this.jobLauncher = jobLauncher;
    }

    public void setJobFromHeader(boolean jobFromHeader) {
        this.jobFromHeader = jobFromHeader;
    }

    public boolean isJobFromHeader() {
        return this.jobFromHeader;
    }

    public JobRegistry getJobRegistry() {
        return this.jobRegistry;
    }

    public void setJobRegistry(JobRegistry jobRegistry) {
        this.jobRegistry = jobRegistry;
    }
}

