/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.util;

import org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class GroupCondition
extends SpringBootCondition {
    private final String group;
    private final String single;

    public GroupCondition(String group, String single) {
        this.group = group;
        this.single = single;
    }

    public ConditionOutcome getMatchOutcome(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata) {
        ConditionMessage.Builder message = ConditionMessage.forCondition((String)this.single, (Object[])new Object[0]);
        Environment environment = conditionContext.getEnvironment();
        return HierarchicalPropertiesEvaluator.evaluate(environment, this.group, this.single) ? ConditionOutcome.match((ConditionMessage)message.because("enabled")) : ConditionOutcome.noMatch((ConditionMessage)message.because("not enabled"));
    }
}

