/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.springrabbit;

import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.component.springrabbit.SpringRabbitMQEndpoint;
import org.apache.camel.component.springrabbit.SpringRabbitMQHelper;
import org.apache.camel.support.DefaultAsyncProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.AsyncRabbitTemplate;
import org.springframework.amqp.rabbit.RabbitMessageFuture;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class SpringRabbitMQProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(SpringRabbitMQProducer.class);
    private RabbitTemplate inOnlyTemplate;
    private AsyncRabbitTemplate inOutTemplate;

    public SpringRabbitMQProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public SpringRabbitMQEndpoint getEndpoint() {
        return (SpringRabbitMQEndpoint)super.getEndpoint();
    }

    public RabbitTemplate getInOnlyTemplate() {
        if (this.inOutTemplate == null) {
            this.inOnlyTemplate = this.getEndpoint().createInOnlyTemplate();
        }
        return this.inOnlyTemplate;
    }

    public void setInOnlyTemplate(RabbitTemplate inOnlyTemplate) {
        this.inOnlyTemplate = inOnlyTemplate;
    }

    public AsyncRabbitTemplate getInOutTemplate() {
        if (this.inOutTemplate == null) {
            this.inOutTemplate = this.getEndpoint().createInOutTemplate();
        }
        this.inOutTemplate.start();
        return this.inOutTemplate;
    }

    public void setInOutTemplate(AsyncRabbitTemplate inOutTemplate) {
        this.inOutTemplate = inOutTemplate;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.getEndpoint().isTestConnectionOnStartup()) {
            this.testConnectionOnStartup();
        }
        if (this.getEndpoint().isAutoDeclareProducer()) {
            AmqpAdmin admin = this.getEndpoint().getComponent().getAmqpAdmin();
            if (admin == null) {
                RabbitAdmin ra = new RabbitAdmin(this.getEndpoint().getConnectionFactory());
                ra.setIgnoreDeclarationExceptions(this.getEndpoint().getComponent().isIgnoreDeclarationExceptions());
                admin = ra;
            }
            this.getEndpoint().declareElements(null, admin);
        }
    }

    protected void doStop() throws Exception {
        if (this.inOnlyTemplate != null) {
            this.inOnlyTemplate.stop();
            this.inOnlyTemplate = null;
        }
        if (this.inOutTemplate != null) {
            this.inOutTemplate.stop();
            this.inOutTemplate = null;
        }
        super.doStop();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (!this.isRunAllowed()) {
            if (exchange.getException() == null) {
                exchange.setException((Throwable)new RejectedExecutionException());
            }
            callback.done(true);
            return true;
        }
        try {
            if (!this.getEndpoint().isDisableReplyTo() && exchange.getPattern().isOutCapable()) {
                return this.processInOut(exchange, callback);
            }
            return this.processInOnly(exchange, callback);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
    }

    protected boolean processInOut(Exchange exchange, AsyncCallback callback) {
        String exchangeName = this.getExchangeName(exchange);
        String routingKey = this.getValue(exchange, "CamelSpringRabbitmqRoutingOverrideKey", this.getEndpoint().getRoutingKey());
        Message msg = this.getMessage(exchange);
        try {
            RabbitMessageFuture future = this.getInOutTemplate().sendAndReceive(exchangeName, routingKey, msg);
            future.whenCompleteAsync((message, throwable) -> {
                try {
                    if (throwable != null) {
                        exchange.setException(throwable);
                    } else {
                        Object body1 = this.getEndpoint().getMessageConverter().fromMessage(message);
                        exchange.getMessage().setBody(body1);
                        Map<String, Object> headers = this.getEndpoint().getMessagePropertiesConverter().fromMessageProperties(message.getMessageProperties(), exchange);
                        if (!headers.isEmpty()) {
                            exchange.getMessage().getHeaders().putAll(headers);
                        }
                    }
                }
                catch (Exception e) {
                    exchange.setException((Throwable)e);
                }
                finally {
                    callback.done(false);
                }
            });
            return false;
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
    }

    private Message getMessage(Exchange exchange) {
        Message msg;
        Object body = exchange.getMessage().getBody();
        if (body instanceof Message) {
            msg = (Message)body;
        } else {
            MessageProperties mp = this.getEndpoint().getMessagePropertiesConverter().toMessageProperties(exchange);
            msg = this.getEndpoint().getMessageConverter().toMessage(body, mp);
        }
        return msg;
    }

    protected boolean processInOnly(Exchange exchange, AsyncCallback callback) {
        String exchangeName = this.getExchangeName(exchange);
        String routingKey = this.getValue(exchange, "CamelSpringRabbitmqRoutingOverrideKey", this.getEndpoint().getRoutingKey());
        Message msg = this.getMessage(exchange);
        String ex = exchangeName;
        String rk = routingKey;
        boolean confirm = "auto".equalsIgnoreCase(this.getEndpoint().getConfirm()) ? this.getEndpoint().getConnectionFactory().isPublisherConfirms() : "enabled".equalsIgnoreCase(this.getEndpoint().getConfirm());
        long timeout = this.getEndpoint().getConfirmTimeout() <= 0L ? Long.MAX_VALUE : this.getEndpoint().getConfirmTimeout();
        try {
            Boolean sent = (Boolean)this.getInOnlyTemplate().invoke(t -> {
                t.send(ex, rk, msg);
                if (confirm) {
                    return t.waitForConfirms(timeout);
                }
                return true;
            });
            if (Boolean.FALSE == sent) {
                exchange.setException((Throwable)new TimeoutException("Message not sent within " + timeout + " millis"));
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    private String getValue(Exchange exchange, String routingOverrideKey, String defaultValue) {
        String routingKey = (String)exchange.getMessage().removeHeader(routingOverrideKey);
        if (routingKey == null) {
            return defaultValue;
        }
        return routingKey;
    }

    private String getExchangeName(Exchange exchange) {
        String exchangeName = this.getValue(exchange, "CamelSpringRabbitmqExchangeOverrideName", this.getEndpoint().getExchangeName());
        return SpringRabbitMQHelper.isDefaultExchange(exchangeName) ? "" : exchangeName;
    }

    protected void testConnectionOnStartup() throws FailedToCreateProducerException {
        Connection conn = null;
        try {
            RabbitTemplate template = this.getInOnlyTemplate();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Testing RabbitMQ Connection on startup for: {}", (Object)this.getEndpoint().getConnectionFactory().getHost());
            }
            conn = template.getConnectionFactory().createConnection();
            LOG.debug("Successfully tested RabbitMQ Connection on startup for: {}", (Object)this.getEndpoint().getConnectionFactory().getHost());
        }
        catch (Exception e) {
            try {
                throw new FailedToCreateProducerException((Endpoint)this.getEndpoint(), (Throwable)e);
            }
            catch (Throwable throwable) {
                RabbitUtils.closeConnection(conn);
                throw throwable;
            }
        }
        RabbitUtils.closeConnection((Connection)conn);
    }
}

