/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.redis.processor.idempotent;

import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.redis.RedisConfiguration;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.service.ServiceSupport;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SetOperations;

@ManagedResource(description="Spring Redis based message id repository")
public class RedisIdempotentRepository
extends ServiceSupport
implements IdempotentRepository {
    private final SetOperations<String, String> setOperations;
    private final String processorName;
    private RedisConfiguration redisConfiguration;
    private RedisTemplate<String, String> redisTemplate;

    public RedisIdempotentRepository(RedisTemplate<String, String> redisTemplate, String processorName) {
        this.setOperations = redisTemplate.opsForSet();
        this.processorName = processorName;
        this.redisTemplate = redisTemplate;
    }

    public RedisIdempotentRepository(String processorName) {
        RedisTemplate redisTemplate;
        this.redisConfiguration = new RedisConfiguration();
        this.redisTemplate = redisTemplate = this.redisConfiguration.getRedisTemplate();
        this.setOperations = redisTemplate.opsForSet();
        redisTemplate.getConnectionFactory().getConnection().flushDb();
        this.processorName = processorName;
    }

    public static RedisIdempotentRepository redisIdempotentRepository(String processorName) {
        return new RedisIdempotentRepository(processorName);
    }

    public static RedisIdempotentRepository redisIdempotentRepository(RedisTemplate<String, String> redisTemplate, String processorName) {
        return new RedisIdempotentRepository(redisTemplate, processorName);
    }

    @ManagedOperation(description="Adds the key to the store")
    public boolean add(String key) {
        if (!this.contains(key)) {
            return this.setOperations.add((Object)this.processorName, (Object[])new String[]{key}) != null;
        }
        return false;
    }

    @ManagedOperation(description="Does the store contain the given key")
    public boolean contains(String key) {
        return this.setOperations.isMember((Object)this.processorName, (Object)key);
    }

    @ManagedOperation(description="Remove the key from the store")
    public boolean remove(String key) {
        return this.setOperations.remove((Object)this.processorName, new Object[]{key}) != null;
    }

    @ManagedOperation(description="Clear the store")
    public void clear() {
        this.redisTemplate.getConnectionFactory().getConnection().flushDb();
    }

    @ManagedAttribute(description="The processor name")
    public String getProcessorName() {
        return this.processorName;
    }

    public boolean confirm(String key) {
        return true;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        if (this.redisConfiguration != null) {
            this.redisConfiguration.stop();
        }
    }
}

