/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.ws.filter.impl;

import jakarta.activation.DataHandler;
import java.util.HashSet;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.camel.Exchange;
import org.apache.camel.attachment.AttachmentMessage;
import org.apache.camel.component.spring.ws.filter.MessageFilter;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapMessage;

public class BasicMessageFilter
implements MessageFilter {
    protected boolean validHeaderName(String name) {
        return !"Content-Type".equalsIgnoreCase(name);
    }

    @Override
    public void filterProducer(Exchange exchange, WebServiceMessage response) {
        if (exchange != null) {
            this.processHeaderAndAttachments((AttachmentMessage)exchange.getIn(AttachmentMessage.class), response);
        }
    }

    @Override
    public void filterConsumer(Exchange exchange, WebServiceMessage response) {
        if (exchange != null) {
            AttachmentMessage responseMessage = (AttachmentMessage)exchange.getMessage(AttachmentMessage.class);
            this.processHeaderAndAttachments(responseMessage, response);
        }
    }

    protected void processHeaderAndAttachments(AttachmentMessage inOrOut, WebServiceMessage response) {
        if (response instanceof SoapMessage) {
            SoapMessage soapMessage = (SoapMessage)response;
            this.processSoapHeader(inOrOut, soapMessage);
            this.doProcessSoapAttachments(inOrOut, soapMessage);
        }
    }

    protected void processSoapHeader(AttachmentMessage inOrOut, SoapMessage soapMessage) {
        boolean isHeaderAvailable;
        boolean bl = isHeaderAvailable = inOrOut != null && inOrOut.getHeaders() != null && !inOrOut.getHeaders().isEmpty();
        if (isHeaderAvailable) {
            this.doProcessSoapHeader(inOrOut, soapMessage);
        }
    }

    protected void doProcessSoapHeader(AttachmentMessage inOrOut, SoapMessage soapMessage) {
        SoapHeader soapHeader = soapMessage.getSoapHeader();
        Map headers = inOrOut.getHeaders();
        HashSet headerKeySet = new HashSet(headers.keySet());
        headerKeySet.remove("CamelSpringWebserviceSoapAction");
        headerKeySet.remove("CamelSpringWebserviceEndpointUri");
        headerKeySet.remove("CamelSpringWebserviceAddressingAction");
        headerKeySet.remove("CamelSpringWebserviceAddressingFaultTo");
        headerKeySet.remove("CamelSpringWebserviceAddressingReplyTo");
        headerKeySet.remove("CamelSpringWebserviceAddressingFaultAction");
        headerKeySet.remove("CamelSpringWebserviceAddressingOutputAction");
        headerKeySet.remove("CamelSpringWebserviceSoapHeader");
        headerKeySet.remove("breadcrumbId");
        for (String name : headerKeySet) {
            if (!this.validHeaderName(name)) continue;
            Object value = headers.get(name);
            if (value instanceof QName) {
                QName qname = (QName)value;
                soapHeader.addHeaderElement(qname);
                continue;
            }
            if (!(value instanceof String)) continue;
            soapHeader.addAttribute(new QName(name), "" + value);
        }
    }

    protected void doProcessSoapAttachments(AttachmentMessage inOrOut, SoapMessage response) {
        if (inOrOut.hasAttachments()) {
            Map attachments = inOrOut.getAttachments();
            HashSet keySet = new HashSet(attachments.keySet());
            for (String key : keySet) {
                response.addAttachment(key, (DataHandler)attachments.get(key));
            }
        }
    }
}

