/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.RedeliveryPolicyDefinition;
import org.apache.camel.model.errorhandler.SpringTransactionErrorHandlerDefinition;
import org.apache.camel.model.errorhandler.TransactionErrorHandlerDefinition;
import org.apache.camel.processor.errorhandler.RedeliveryPolicy;
import org.apache.camel.reifier.errorhandler.ErrorHandlerReifier;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.ErrorHandler;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.spring.spi.SpringTransactionPolicy;
import org.apache.camel.spring.spi.TransactionErrorHandler;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class TransactionErrorHandlerReifier
extends ErrorHandlerReifier<SpringTransactionErrorHandlerDefinition> {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionErrorHandlerReifier.class);

    public TransactionErrorHandlerReifier(Route route, SpringTransactionErrorHandlerDefinition definition) {
        super(route, (ErrorHandlerFactory)definition);
    }

    public Processor createErrorHandler(Processor processor) throws Exception {
        TransactionTemplate transactionTemplate = this.resolveTransactionTemplate((TransactionErrorHandlerDefinition)this.definition, this.camelContext);
        ObjectHelper.notNull((Object)transactionTemplate, (String)"transactionTemplate", (Object)((Object)this));
        RedeliveryPolicy redeliveryPolicy = this.resolveRedeliveryPolicy((TransactionErrorHandlerDefinition)this.definition, this.camelContext);
        CamelLogger logger = this.resolveLogger((TransactionErrorHandlerDefinition)this.definition, this.camelContext);
        LoggingLevel rollbackLoggingLevel = this.resolveRollbackLoggingLevel((TransactionErrorHandlerDefinition)this.definition, this.camelContext);
        TransactionErrorHandler answer = new TransactionErrorHandler(this.camelContext, processor, logger, this.getProcessor(((SpringTransactionErrorHandlerDefinition)this.definition).getOnRedeliveryProcessor(), ((SpringTransactionErrorHandlerDefinition)this.definition).getOnRedeliveryRef()), redeliveryPolicy, transactionTemplate, this.resolveRetryWhilePolicy((TransactionErrorHandlerDefinition)this.definition, this.camelContext), this.getExecutorService(((SpringTransactionErrorHandlerDefinition)this.definition).getExecutorServiceBean(), ((SpringTransactionErrorHandlerDefinition)this.definition).getExecutorServiceRef()), rollbackLoggingLevel, this.getProcessor(((SpringTransactionErrorHandlerDefinition)this.definition).getOnExceptionOccurredProcessor(), ((SpringTransactionErrorHandlerDefinition)this.definition).getOnExceptionOccurredRef()));
        this.configure((ErrorHandler)answer);
        return answer;
    }

    private TransactionTemplate resolveTransactionTemplate(TransactionErrorHandlerDefinition definition, CamelContext camelContext) {
        Map mapPolicy;
        TransactionTemplate answer = null;
        SpringTransactionPolicy policy = (SpringTransactionPolicy)definition.getTransactedPolicy();
        if (policy == null && definition.getTransactedPolicyRef() != null) {
            policy = (SpringTransactionPolicy)this.mandatoryLookup(definition.getTransactedPolicyRef(), SpringTransactionPolicy.class);
        }
        if (policy != null) {
            answer = policy.getTransactionTemplate();
        }
        if (answer == null && (mapPolicy = this.findByTypeWithName(SpringTransactionPolicy.class)) != null && mapPolicy.size() == 1 && (policy = (SpringTransactionPolicy)mapPolicy.values().iterator().next()) != null) {
            answer = policy.getTransactionTemplate();
        }
        if (answer == null && (policy = (SpringTransactionPolicy)this.lookupByNameAndType("PROPAGATION_REQUIRED", SpringTransactionPolicy.class)) != null) {
            answer = policy.getTransactionTemplate();
        }
        if (answer == null) {
            Map mapTemplate = this.findByTypeWithName(TransactionTemplate.class);
            if (mapTemplate == null || mapTemplate.isEmpty()) {
                LOG.trace("No TransactionTemplate found in registry.");
            } else if (mapTemplate.size() == 1) {
                answer = (TransactionTemplate)mapTemplate.values().iterator().next();
            } else {
                LOG.debug("Found {} TransactionTemplate in registry. Cannot determine which one to use. Please configure a TransactionTemplate on the TransactionErrorHandlerBuilder", (Object)mapTemplate.size());
            }
        }
        if (answer == null) {
            Map mapManager = this.findByTypeWithName(PlatformTransactionManager.class);
            if (mapManager == null || mapManager.isEmpty()) {
                LOG.trace("No PlatformTransactionManager found in registry.");
            } else if (mapManager.size() == 1) {
                answer = new TransactionTemplate((PlatformTransactionManager)mapManager.values().iterator().next());
            } else {
                LOG.debug("Found {} PlatformTransactionManager in registry. Cannot determine which one to use for TransactionTemplate. Please configure a TransactionTemplate on the TransactionErrorHandlerBuilder", (Object)mapManager.size());
            }
        }
        if (answer != null) {
            LOG.debug("Found TransactionTemplate in registry to use: {}", (Object)answer);
        }
        return answer;
    }

    private CamelLogger resolveLogger(TransactionErrorHandlerDefinition definition, CamelContext camelContext) {
        CamelLogger answer = definition.getLoggerBean();
        if (answer == null && definition.getLoggerRef() != null) {
            answer = (CamelLogger)this.mandatoryLookup(definition.getLoggerRef(), CamelLogger.class);
        }
        if (answer == null) {
            answer = new CamelLogger(LoggerFactory.getLogger(TransactionErrorHandler.class), LoggingLevel.ERROR);
        }
        if (definition.getLevel() != null) {
            answer.setLevel((LoggingLevel)this.parse(LoggingLevel.class, definition.getLevel()));
        }
        return answer;
    }

    private LoggingLevel resolveRollbackLoggingLevel(TransactionErrorHandlerDefinition definition, CamelContext camelContext) {
        LoggingLevel answer = LoggingLevel.WARN;
        if (definition.getRollbackLoggingLevel() != null) {
            answer = (LoggingLevel)this.parse(LoggingLevel.class, definition.getRollbackLoggingLevel());
        }
        return answer;
    }

    private RedeliveryPolicy resolveRedeliveryPolicy(TransactionErrorHandlerDefinition definition, CamelContext camelContext) {
        RedeliveryPolicy answer = null;
        RedeliveryPolicyDefinition def = definition.getRedeliveryPolicy();
        if (def == null && definition.getRedeliveryPolicyRef() != null) {
            def = (RedeliveryPolicyDefinition)this.lookupByNameAndType(definition.getRedeliveryPolicyRef(), RedeliveryPolicyDefinition.class);
        }
        if (def != null) {
            answer = ErrorHandlerReifier.createRedeliveryPolicy((RedeliveryPolicyDefinition)def, (CamelContext)camelContext, null);
        }
        if (def == null && definition.getRedeliveryPolicyRef() != null) {
            answer = (RedeliveryPolicy)this.mandatoryLookup(definition.getRedeliveryPolicyRef(), RedeliveryPolicy.class);
        }
        if (answer == null) {
            answer = RedeliveryPolicy.DEFAULT_POLICY;
        }
        return answer;
    }

    private Predicate resolveRetryWhilePolicy(TransactionErrorHandlerDefinition definition, CamelContext camelContext) {
        Predicate answer = definition.getRetryWhilePredicate();
        if (answer == null && definition.getRetryWhileRef() != null) {
            Language bean = camelContext.resolveLanguage("bean");
            answer = bean.createPredicate(definition.getRetryWhileRef());
            answer.initPredicate(camelContext);
        }
        return answer;
    }

    protected synchronized ScheduledExecutorService getExecutorService(ScheduledExecutorService executorService, String executorServiceRef) {
        if (executorService == null || executorService.isShutdown()) {
            if (executorServiceRef != null) {
                executorService = (ScheduledExecutorService)this.lookupByNameAndType(executorServiceRef, ScheduledExecutorService.class);
                if (executorService == null) {
                    ExecutorServiceManager manager = this.camelContext.getExecutorServiceManager();
                    ThreadPoolProfile profile = manager.getThreadPoolProfile(executorServiceRef);
                    executorService = manager.newScheduledThreadPool((Object)this, executorServiceRef, profile);
                }
                if (executorService == null) {
                    throw new IllegalArgumentException("ExecutorService " + executorServiceRef + " not found in registry.");
                }
            } else {
                executorService = null;
            }
        }
        return executorService;
    }
}

