/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultExchangeHolder;
import org.apache.camel.processor.aggregate.jdbc.ClassLoadingAwareObjectInputStream;
import org.apache.camel.util.IOHelper;

public class JdbcCamelCodec {
    public byte[] marshallExchange(CamelContext camelContext, Exchange exchange, boolean allowSerializedHeaders) throws IOException {
        DefaultExchangeHolder pe = DefaultExchangeHolder.marshal((Exchange)exchange, (boolean)false, (boolean)allowSerializedHeaders);
        DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedSize", (Serializable)((Serializable)exchange.getProperty("CamelAggregatedSize", Integer.class)));
        DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedTimeout", (Serializable)((Serializable)exchange.getProperty("CamelAggregatedTimeout", Long.class)));
        DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedCompletedBy", (Serializable)((Serializable)exchange.getProperty("CamelAggregatedCompletedBy", String.class)));
        DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedCorrelationKey", (Serializable)((Serializable)exchange.getProperty("CamelAggregatedCorrelationKey", String.class)));
        DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedCorrelationKey", (Serializable)((Serializable)exchange.getProperty("CamelAggregatedCorrelationKey", String.class)));
        DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedCollectionGuard", (Serializable)((Serializable)exchange.getProperty("CamelAggregatedCollectionGuard", String.class)));
        if (exchange.getFromEndpoint() != null) {
            DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedFromEndpoint", (Serializable)((Object)exchange.getFromEndpoint().getEndpointUri()));
        }
        return this.encode(pe);
    }

    public Exchange unmarshallExchange(CamelContext camelContext, byte[] buffer) throws IOException, ClassNotFoundException {
        Endpoint fromEndpoint;
        DefaultExchangeHolder pe = this.decode(camelContext, buffer);
        DefaultExchange answer = new DefaultExchange(camelContext);
        DefaultExchangeHolder.unmarshal((Exchange)answer, (DefaultExchangeHolder)pe);
        String fromEndpointUri = (String)answer.removeProperty("CamelAggregatedFromEndpoint");
        if (fromEndpointUri != null && (fromEndpoint = camelContext.hasEndpoint(fromEndpointUri)) != null) {
            answer.setFromEndpoint(fromEndpoint);
        }
        return answer;
    }

    private byte[] encode(Object object) throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        ObjectOutputStream objectOut = new ObjectOutputStream(bytesOut);
        objectOut.writeObject(object);
        objectOut.close();
        byte[] data = bytesOut.toByteArray();
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultExchangeHolder decode(CamelContext camelContext, byte[] dataIn) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(dataIn);
        ClassLoadingAwareObjectInputStream objectIn = null;
        Object obj = null;
        try {
            objectIn = new ClassLoadingAwareObjectInputStream(camelContext, bytesIn);
            obj = objectIn.readObject();
        }
        catch (Throwable throwable) {
            IOHelper.close(objectIn);
            throw throwable;
        }
        IOHelper.close((Closeable)objectIn);
        return (DefaultExchangeHolder)obj;
    }
}

