/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql;

import java.util.Map;
import javax.sql.DataSource;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.sql.RowMapperFactory;
import org.apache.camel.component.sql.SqlEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.PropertiesHelper;
import org.springframework.jdbc.core.JdbcTemplate;

@org.apache.camel.spi.annotations.Component(value="sql")
public class SqlComponent
extends DefaultComponent {
    @Metadata(autowired=true)
    private DataSource dataSource;
    @Metadata(label="advanced", defaultValue="true")
    private boolean usePlaceholder = true;
    @Metadata(label="advanced", autowired=true)
    private RowMapperFactory rowMapperFactory;

    public SqlComponent() {
    }

    public SqlComponent(Class<? extends Endpoint> endpointClass) {
    }

    public SqlComponent(CamelContext context) {
        super(context);
    }

    public SqlComponent(CamelContext context, Class<? extends Endpoint> endpointClass) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        RowMapperFactory factory;
        String onConsumeBatchComplete;
        String onConsumeFailed;
        String onConsume;
        String parameterPlaceholderSubstitute = (String)this.getAndRemoveParameter(parameters, "placeholder", String.class, "#");
        String query = remaining;
        if (this.usePlaceholder) {
            query = query.replaceAll(parameterPlaceholderSubstitute, "?");
        }
        if ((onConsume = (String)this.getAndRemoveParameter(parameters, "consumer.onConsume", String.class)) == null) {
            onConsume = (String)this.getAndRemoveParameter(parameters, "onConsume", String.class);
        }
        if (onConsume != null && this.usePlaceholder) {
            onConsume = onConsume.replaceAll(parameterPlaceholderSubstitute, "?");
        }
        if ((onConsumeFailed = (String)this.getAndRemoveParameter(parameters, "consumer.onConsumeFailed", String.class)) == null) {
            onConsumeFailed = (String)this.getAndRemoveParameter(parameters, "onConsumeFailed", String.class);
        }
        if (onConsumeFailed != null && this.usePlaceholder) {
            onConsumeFailed = onConsumeFailed.replaceAll(parameterPlaceholderSubstitute, "?");
        }
        if ((onConsumeBatchComplete = (String)this.getAndRemoveParameter(parameters, "consumer.onConsumeBatchComplete", String.class)) == null) {
            onConsumeBatchComplete = (String)this.getAndRemoveParameter(parameters, "onConsumeBatchComplete", String.class);
        }
        if (onConsumeBatchComplete != null && this.usePlaceholder) {
            onConsumeBatchComplete = onConsumeBatchComplete.replaceAll(parameterPlaceholderSubstitute, "?");
        }
        if ((factory = (RowMapperFactory)this.getAndRemoveParameter(parameters, "rowMapperFactory", RowMapperFactory.class)) == null) {
            factory = this.rowMapperFactory;
        }
        SqlEndpoint endpoint = new SqlEndpoint(uri, (Component)this);
        endpoint.setQuery(query);
        endpoint.setPlaceholder(parameterPlaceholderSubstitute);
        endpoint.setUsePlaceholder(this.isUsePlaceholder());
        endpoint.setOnConsume(onConsume);
        endpoint.setOnConsumeFailed(onConsumeFailed);
        endpoint.setOnConsumeBatchComplete(onConsumeBatchComplete);
        endpoint.setRowMapperFactory(factory);
        this.setProperties((Endpoint)endpoint, parameters);
        DataSource ds = this.dataSource;
        if (endpoint.getDataSource() != null) {
            ds = endpoint.getDataSource();
        }
        if (ds == null) {
            throw new IllegalArgumentException("DataSource must be configured");
        }
        JdbcTemplate jdbcTemplate = new JdbcTemplate(ds);
        Map templateOptions = PropertiesHelper.extractProperties(parameters, (String)"template.");
        PropertyBindingSupport.bindProperties((CamelContext)this.getCamelContext(), (Object)jdbcTemplate, (Map)templateOptions);
        endpoint.setJdbcTemplate(jdbcTemplate);
        endpoint.setDataSource(ds);
        endpoint.setTemplateOptions(templateOptions);
        return endpoint;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setUsePlaceholder(boolean usePlaceholder) {
        this.usePlaceholder = usePlaceholder;
    }

    public boolean isUsePlaceholder() {
        return this.usePlaceholder;
    }

    public RowMapperFactory getRowMapperFactory() {
        return this.rowMapperFactory;
    }

    public void setRowMapperFactory(RowMapperFactory rowMapperFactory) {
        this.rowMapperFactory = rowMapperFactory;
    }
}

