/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ssh;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.apache.sshd.common.cipher.ECCurves;
import org.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SSHPublicKeyHolder {
    private static final String SSH_RSA = "ssh-rsa";
    private static final String SSH_DSS = "ssh-dss";
    private static final String SSH_ECDSA_PREFIX = "ecdsa-sha2-";
    private static final String SSH_ECDSA = "ecdsa-sha2-nistp256";
    private static final String SSH_ECDSA_384 = "ecdsa-sha2-nistp384";
    private static final String SSH_ECDSA_521 = "ecdsa-sha2-nistp521";
    private static final String SSH_ED25519 = "ssh-ed25519";
    private String keyType;
    private BigInteger e;
    private BigInteger m;
    private BigInteger p;
    private BigInteger q;
    private BigInteger g;
    private BigInteger y;
    private String curveName;
    private ECPoint ecPoint;
    private ECParameterSpec ecParams;
    private final ByteArrayOutputStream edKeyEncoded = new ByteArrayOutputStream();

    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public BigInteger getE() {
        return this.e;
    }

    public void setE(BigInteger e) {
        this.e = e;
    }

    public BigInteger getM() {
        return this.m;
    }

    public void setM(BigInteger m) {
        this.m = m;
    }

    public BigInteger getG() {
        return this.g;
    }

    public void setG(BigInteger g) {
        this.g = g;
    }

    public BigInteger getP() {
        return this.p;
    }

    public void setP(BigInteger p) {
        this.p = p;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public void setQ(BigInteger q) {
        this.q = q;
    }

    public BigInteger getY() {
        return this.y;
    }

    public void setY(BigInteger y) {
        this.y = y;
    }

    public void push(byte[] keyPart) {
        if (this.keyType == null) {
            this.keyType = new String(keyPart, StandardCharsets.UTF_8);
            if (SSH_ED25519.equals(this.keyType)) {
                this.encode(this.edKeyEncoded, this.keyType);
            }
            return;
        }
        if (SSH_RSA.equals(this.keyType)) {
            if (this.e == null) {
                this.e = new BigInteger(keyPart);
                return;
            }
            if (this.m == null) {
                this.m = new BigInteger(keyPart);
                return;
            }
        }
        if (SSH_DSS.equals(this.keyType)) {
            if (this.p == null) {
                this.p = new BigInteger(keyPart);
                return;
            }
            if (this.q == null) {
                this.q = new BigInteger(keyPart);
                return;
            }
            if (this.g == null) {
                this.g = new BigInteger(keyPart);
                return;
            }
            if (this.y == null) {
                this.y = new BigInteger(keyPart);
                return;
            }
        }
        if (this.keyType.equals(SSH_ED25519)) {
            this.encode(this.edKeyEncoded, keyPart);
            return;
        }
        if (this.keyType.startsWith(SSH_ECDSA_PREFIX)) {
            if (this.curveName == null) {
                this.curveName = new String(keyPart, StandardCharsets.UTF_8);
                return;
            }
            if (this.ecPoint == null) {
                this.ecParams = ECCurves.fromKeyType((String)this.keyType).getParameters();
                this.ecPoint = ECCurves.octetStringToEcPoint((byte[])keyPart);
            }
        }
    }

    public PublicKey toPublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory factory;
        KeySpec dsaPublicKeySpec;
        PublicKey returnValue = null;
        if (SSH_RSA.equals(this.keyType)) {
            dsaPublicKeySpec = new RSAPublicKeySpec(this.m, this.e);
            factory = KeyFactory.getInstance("RSA");
            returnValue = factory.generatePublic(dsaPublicKeySpec);
        }
        if (SSH_DSS.equals(this.keyType)) {
            dsaPublicKeySpec = new DSAPublicKeySpec(this.y, this.p, this.q, this.g);
            factory = KeyFactory.getInstance("DSA");
            returnValue = factory.generatePublic(dsaPublicKeySpec);
        }
        if (SSH_ED25519.equals(this.keyType)) {
            OpenSSHPublicKeySpec ed25519PublicKeySpec = new OpenSSHPublicKeySpec(this.edKeyEncoded.toByteArray());
            factory = KeyFactory.getInstance("ED25519", (Provider)new BouncyCastleProvider());
            returnValue = factory.generatePublic((KeySpec)ed25519PublicKeySpec);
        }
        if (this.keyType.startsWith(SSH_ECDSA_PREFIX)) {
            ECPublicKeySpec spec = new ECPublicKeySpec(this.ecPoint, this.ecParams);
            factory = KeyFactory.getInstance("EC");
            returnValue = factory.generatePublic(spec);
        }
        return returnValue;
    }

    private void encode(ByteArrayOutputStream target, byte[] value) {
        byte[] result = new byte[4 + value.length];
        result[0] = (byte)((value.length & 0xFF) << 24);
        result[1] = (byte)((value.length & 0xFF) << 16);
        result[2] = (byte)((value.length & 0xFF) << 8);
        result[3] = (byte)(value.length & 0xFF);
        System.arraycopy(value, 0, result, 4, value.length);
        try {
            target.write(result);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void encode(ByteArrayOutputStream target, String v) {
        byte[] value = v.getBytes(StandardCharsets.UTF_8);
        this.encode(target, value);
    }
}

