/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;

public abstract class ChildServiceSupport
extends ServiceSupport {
    protected volatile List<Service> childServices;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == 4) {
                this.log.trace("Service: {} already started", (Object)this);
                return;
            }
            if (this.status == 3) {
                this.log.trace("Service: {} already starting", (Object)this);
                return;
            }
            try {
                this.initService(this.childServices);
            }
            catch (Exception e) {
                this.status = 11;
                this.log.trace("Error while initializing service: " + (Object)((Object)this), (Throwable)e);
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
            try {
                this.status = 3;
                this.log.trace("Starting service: {}", (Object)this);
                ServiceHelper.startService(this.childServices);
                this.doStart();
                this.status = 4;
                this.log.trace("Service: {} started", (Object)this);
            }
            catch (Exception e) {
                this.status = 11;
                this.log.trace("Error while starting service: " + (Object)((Object)this), (Throwable)e);
                ServiceHelper.stopService(this.childServices);
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == 8 || this.status == 9 || this.status == 10) {
                this.log.trace("Service: {} already stopped", (Object)this);
                return;
            }
            if (this.status == 7) {
                this.log.trace("Service: {} already stopping", (Object)this);
                return;
            }
            this.status = 7;
            this.log.trace("Stopping service: {}", (Object)this);
            try {
                this.doStop();
                ServiceHelper.stopService(this.childServices);
                this.status = 8;
                this.log.trace("Service: {} stopped service", (Object)this);
            }
            catch (Exception e) {
                this.status = 11;
                this.log.trace("Error while stopping service: " + (Object)((Object)this), (Throwable)e);
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == 10) {
                this.log.trace("Service: {} already shut down", (Object)this);
                return;
            }
            if (this.status == 9) {
                this.log.trace("Service: {} already shutting down", (Object)this);
                return;
            }
            this.stop();
            this.status = 10;
            this.log.trace("Shutting down service: {}", (Object)this);
            try {
                this.doShutdown();
                ServiceHelper.stopAndShutdownServices(this.childServices);
                this.log.trace("Service: {} shut down", (Object)this);
                this.status = 10;
            }
            catch (Exception e) {
                this.status = 11;
                this.log.trace("Error shutting down service: " + (Object)((Object)this), (Throwable)e);
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildService(Object childService) {
        if (childService instanceof Service) {
            if (this.childServices == null) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.childServices == null) {
                        this.childServices = new CopyOnWriteArrayList<Service>();
                    }
                }
            }
            this.childServices.add((Service)childService);
        }
    }

    protected boolean removeChildService(Object childService) {
        return this.childServices != null && this.childServices.remove(childService);
    }

    private void initService(List<Service> services) {
        if (services != null) {
            services.forEach(Service::init);
        }
    }
}

