/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.component;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodParser;

public class ArgumentSubstitutionParser<T>
extends ApiMethodParser<T> {
    private final Map<Pattern, Map<Pattern, List<NameReplacement>>> methodMap;

    public ArgumentSubstitutionParser(Class<T> proxyType, Substitution[] substitutions) {
        super(proxyType);
        LinkedHashMap regexMap = new LinkedHashMap();
        for (Substitution substitution : substitutions) {
            ArrayList<NameReplacement> replacements;
            substitution.validate();
            NameReplacement nameReplacement = new NameReplacement();
            nameReplacement.replacement = substitution.replacement;
            if (substitution.argType != null) {
                nameReplacement.typePattern = Pattern.compile(substitution.argType);
            }
            nameReplacement.replaceWithType = substitution.replaceWithType;
            LinkedHashMap<String, ArrayList<NameReplacement>> replacementMap = (LinkedHashMap<String, ArrayList<NameReplacement>>)regexMap.get(substitution.method);
            if (replacementMap == null) {
                replacementMap = new LinkedHashMap<String, ArrayList<NameReplacement>>();
                regexMap.put(substitution.method, replacementMap);
            }
            if ((replacements = (ArrayList<NameReplacement>)replacementMap.get(substitution.argName)) == null) {
                replacements = new ArrayList<NameReplacement>();
                replacementMap.put(substitution.argName, replacements);
            }
            replacements.add(nameReplacement);
        }
        this.methodMap = new LinkedHashMap<Pattern, Map<Pattern, List<NameReplacement>>>();
        for (Map.Entry entry : regexMap.entrySet()) {
            LinkedHashMap argMap = new LinkedHashMap();
            for (Map.Entry arg : ((Map)entry.getValue()).entrySet()) {
                argMap.put(Pattern.compile((String)arg.getKey()), arg.getValue());
            }
            this.methodMap.put(Pattern.compile((String)entry.getKey()), argMap);
        }
    }

    @Override
    public List<ApiMethodParser.ApiMethodModel> processResults(List<ApiMethodParser.ApiMethodModel> parseResult) {
        ArrayList<ApiMethodParser.ApiMethodModel> result = new ArrayList<ApiMethodParser.ApiMethodModel>();
        for (ApiMethodParser.ApiMethodModel model : parseResult) {
            for (Map.Entry<Pattern, Map<Pattern, List<NameReplacement>>> methodEntry : this.methodMap.entrySet()) {
                if (!methodEntry.getKey().matcher(model.getName()).matches()) continue;
                ArrayList<ApiMethodArg> updatedArguments = new ArrayList<ApiMethodArg>();
                Map<Pattern, List<NameReplacement>> argMap = methodEntry.getValue();
                for (ApiMethodArg argument : model.getArguments()) {
                    Class<?> argType = argument.getType();
                    String typeArgs = argument.getTypeArgs();
                    String argTypeName = argType.getCanonicalName();
                    for (Map.Entry<Pattern, List<NameReplacement>> argEntry : argMap.entrySet()) {
                        Matcher matcher = argEntry.getKey().matcher(argument.getName());
                        if (!matcher.find()) continue;
                        List<NameReplacement> adapters = argEntry.getValue();
                        for (NameReplacement adapter : adapters) {
                            String newName;
                            if (adapter.typePattern == null) {
                                String newName2 = this.getJavaArgName(matcher.replaceAll(adapter.replacement));
                                argument = new ApiMethodArg(newName2, argType, typeArgs);
                                continue;
                            }
                            Matcher typeMatcher = adapter.typePattern.matcher(argTypeName);
                            if (!typeMatcher.find()) continue;
                            if (!adapter.replaceWithType) {
                                newName = this.getJavaArgName(matcher.replaceAll(adapter.replacement));
                                argument = new ApiMethodArg(newName, argType, typeArgs);
                                continue;
                            }
                            newName = this.getJavaArgName(typeMatcher.replaceAll(adapter.replacement));
                            argument = new ApiMethodArg(newName, argType, typeArgs);
                        }
                    }
                    updatedArguments.add(argument);
                }
                model = new ApiMethodParser.ApiMethodModel(model.getUniqueName(), model.getName(), model.getResultType(), updatedArguments, model.getMethod());
            }
            result.add(model);
        }
        return result;
    }

    private String getJavaArgName(String name) {
        char firstChar = name.charAt(0);
        if (Character.isLowerCase(firstChar)) {
            return name;
        }
        return Character.toLowerCase(firstChar) + name.substring(1);
    }

    private static class NameReplacement {
        private String replacement;
        private Pattern typePattern;
        private boolean replaceWithType;

        private NameReplacement() {
        }
    }

    public static class Substitution {
        private String method;
        private String argName;
        private String argType;
        private String replacement;
        private boolean replaceWithType;

        public Substitution(String method, String argName, String replacement) {
            this.method = method;
            this.argName = argName;
            this.replacement = replacement;
        }

        public Substitution(String method, String argName, String argType, String replacement) {
            this(method, argName, replacement);
            this.argType = argType;
        }

        public Substitution(String method, String argName, String argType, String replacement, boolean replaceWithType) {
            this(method, argName, argType, replacement);
            this.replaceWithType = replaceWithType;
        }

        public void validate() {
            if (this.method == null || this.argName == null || this.replacement == null) {
                throw new IllegalArgumentException("Properties method, argName and replacement MUST be provided");
            }
        }
    }
}

