/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.camel.AfterPropertiesConfigured;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerAware;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.PropertiesHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.camel.util.function.Suppliers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultComponent
extends ServiceSupport
implements Component {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultComponent.class);
    private static final Pattern RAW_PATTERN = Pattern.compile("RAW[({].*&&.*[)}]");
    private volatile PropertyConfigurer componentPropertyConfigurer;
    private volatile PropertyConfigurer endpointPropertyConfigurer;
    private volatile String defaultName;
    private final List<Supplier<ComponentExtension>> extensions = new ArrayList<Supplier<ComponentExtension>>();
    private CamelContext camelContext;
    @Metadata(label="advanced", defaultValue="true", description="Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.")
    private boolean autowiredEnabled = true;
    @Metadata(label="consumer", description="Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.")
    private boolean bridgeErrorHandler;
    @Metadata(label="producer", description="Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.")
    private boolean lazyStartProducer;

    public DefaultComponent() {
    }

    public DefaultComponent(CamelContext context) {
        this.camelContext = context;
    }

    public Endpoint createEndpoint(String uri, Map<String, Object> properties) throws Exception {
        Endpoint endpoint;
        Map parameters;
        String encodedUri = UnsafeUriCharactersEncoder.encode((String)uri);
        URI u = new URI(encodedUri);
        String path = u.getScheme() != null ? URISupport.extractRemainderPath((URI)u, (boolean)this.useRawUri()) : null;
        if (this.useRawUri()) {
            int idx = uri.indexOf(63);
            String query = idx > -1 ? uri.substring(idx + 1) : u.getRawQuery();
            parameters = URISupport.parseQuery((String)query, (boolean)true);
        } else {
            parameters = URISupport.parseParameters((URI)u);
        }
        if (properties != null) {
            parameters.putAll(properties);
        }
        parameters.remove("hash");
        if (this.resolveRawParameterValues()) {
            URISupport.resolveRawParameterValues((Map)parameters);
        }
        uri = this.useRawUri() ? uri : encodedUri;
        this.validateURI(uri, path, parameters);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating endpoint uri=[{}], path=[{}], parameters=[{}]", new Object[]{URISupport.sanitizeUri((String)uri), URISupport.sanitizePath((String)path), parameters});
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Creating endpoint uri=[{}], path=[{}]", (Object)URISupport.sanitizeUri((String)uri), (Object)URISupport.sanitizePath((String)path));
        }
        boolean bridge = this.bridgeErrorHandler || this.getCamelContext().getGlobalEndpointConfiguration().isBridgeErrorHandler();
        Boolean bool = this.getAndRemoveParameter(parameters, "bridgeErrorHandler", Boolean.class);
        if (bool != null) {
            bridge = bool;
        }
        boolean lazy = this.lazyStartProducer || this.getCamelContext().getGlobalEndpointConfiguration().isLazyStartProducer();
        bool = this.getAndRemoveParameter(parameters, "lazyStartProducer", Boolean.class);
        if (bool != null) {
            lazy = bool;
        }
        boolean autowire = this.camelContext.isAutowiredEnabled() != false && (this.autowiredEnabled || this.getCamelContext().getGlobalEndpointConfiguration().isAutowiredEnabled());
        bool = this.getAndRemoveParameter(parameters, "autowiredEnabled", Boolean.class);
        if (bool != null) {
            autowire = bool;
        }
        if ((endpoint = this.createEndpoint(uri, path, parameters)) == null) {
            return null;
        }
        endpoint.setCamelContext(this.getCamelContext());
        if (endpoint instanceof DefaultEndpoint) {
            DefaultEndpoint de = (DefaultEndpoint)endpoint;
            de.setBridgeErrorHandler(bridge);
            de.setLazyStartProducer(lazy);
            de.setAutowiredEnabled(autowire);
        }
        this.setProperties(endpoint, (Map<String, Object>)parameters);
        if (!endpoint.isLenientProperties()) {
            this.validateParameters(uri, parameters, null);
        }
        if (endpoint instanceof AfterPropertiesConfigured) {
            ((AfterPropertiesConfigured)endpoint).afterPropertiesConfigured(this.getCamelContext());
        }
        this.afterConfiguration(uri, path, endpoint, parameters);
        return endpoint;
    }

    public Endpoint createEndpoint(String uri) throws Exception {
        return this.createEndpoint(uri, null);
    }

    public boolean useRawUri() {
        return false;
    }

    public boolean isLazyStartProducer() {
        return this.lazyStartProducer;
    }

    public void setLazyStartProducer(boolean lazyStartProducer) {
        this.lazyStartProducer = lazyStartProducer;
    }

    public boolean isBridgeErrorHandler() {
        return this.bridgeErrorHandler;
    }

    public void setBridgeErrorHandler(boolean bridgeErrorHandler) {
        this.bridgeErrorHandler = bridgeErrorHandler;
    }

    public boolean isAutowiredEnabled() {
        return this.autowiredEnabled;
    }

    public void setAutowiredEnabled(boolean autowiredEnabled) {
        this.autowiredEnabled = autowiredEnabled;
    }

    protected void afterConfiguration(String uri, String remaining, Endpoint endpoint, Map<String, Object> parameters) throws Exception {
    }

    protected void validateParameters(String uri, Map<String, Object> parameters, String optionPrefix) {
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        Map param = parameters;
        if (optionPrefix != null) {
            param = PropertiesHelper.extractProperties(parameters, (String)optionPrefix);
        }
        if (param.size() > 0) {
            throw new ResolveEndpointFailedException(uri, "There are " + param.size() + " parameters that couldn't be set on the endpoint. Check the uri if the parameters are spelt correctly and that they are properties of the endpoint. Unknown parameters=[" + param + "]");
        }
    }

    protected void validateURI(String uri, String path, Map<String, Object> parameters) {
        Matcher m;
        if (uri.contains("&&") && !(m = RAW_PATTERN.matcher(uri)).find()) {
            throw new ResolveEndpointFailedException(uri, "Invalid uri syntax: Double && marker found. Check the uri and remove the duplicate & marker.");
        }
        if (uri.endsWith("&")) {
            throw new ResolveEndpointFailedException(uri, "Invalid uri syntax: Trailing & marker found. Check the uri and remove the trailing & marker.");
        }
    }

    protected boolean resolveRawParameterValues() {
        return true;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext context) {
        this.camelContext = context;
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    protected void doBuild() throws Exception {
        org.apache.camel.spi.annotations.Component ann;
        if (this.defaultName == null && (ann = (org.apache.camel.spi.annotations.Component)ObjectHelper.getAnnotation((Object)((Object)this), org.apache.camel.spi.annotations.Component.class)) != null) {
            this.defaultName = ann.value();
            if (this.defaultName.contains(",")) {
                this.defaultName = StringHelper.before((String)this.defaultName, (String)",");
            }
        }
        if (this.defaultName != null) {
            String componentConfigurerName = this.defaultName + "-component-configurer";
            this.componentPropertyConfigurer = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getConfigurerResolver().resolvePropertyConfigurer(componentConfigurerName, this.getCamelContext());
            String endpointConfigurerName = this.defaultName + "-endpoint-configurer";
            this.endpointPropertyConfigurer = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getConfigurerResolver().resolvePropertyConfigurer(endpointConfigurerName, this.getCamelContext());
        }
    }

    protected void doInit() throws Exception {
        ObjectHelper.notNull((Object)this.getCamelContext(), (String)"camelContext");
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    protected abstract Endpoint createEndpoint(String var1, String var2, Map<String, Object> var3) throws Exception;

    protected void setProperties(Endpoint endpoint, Map<String, Object> parameters) throws Exception {
        endpoint.configureProperties(parameters);
    }

    protected void setProperties(Object bean, Map<String, Object> parameters) throws Exception {
        this.setProperties(this.getCamelContext(), bean, parameters);
    }

    protected void setProperties(CamelContext camelContext, Object bean, Map<String, Object> parameters) throws Exception {
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        Object configurer = bean instanceof Component ? this.getComponentPropertyConfigurer() : (bean instanceof Endpoint ? this.getEndpointPropertyConfigurer() : (bean instanceof PropertyConfigurerAware ? ((PropertyConfigurerAware)bean).getPropertyConfigurer(bean) : null));
        PropertyBindingSupport.build().withConfigurer((PropertyConfigurer)configurer).withIgnoreCase(true).bind(camelContext, bean, parameters);
    }

    public PropertyConfigurer getComponentPropertyConfigurer() {
        return this.componentPropertyConfigurer;
    }

    public PropertyConfigurer getEndpointPropertyConfigurer() {
        return this.endpointPropertyConfigurer;
    }

    protected boolean useIntrospectionOnEndpoint() {
        return true;
    }

    public <T> T getAndRemoveParameter(Map<String, Object> parameters, String key, Class<T> type) {
        return this.getAndRemoveParameter(parameters, key, type, null);
    }

    public <T> T getAndRemoveParameter(Map<String, Object> parameters, String key, Class<T> type, T defaultValue) {
        Object value = parameters.remove(key);
        if (value != null) {
            return CamelContextHelper.mandatoryConvertTo(this.getCamelContext(), type, value);
        }
        value = defaultValue;
        if (value == null) {
            return null;
        }
        return CamelContextHelper.mandatoryConvertTo(this.getCamelContext(), type, value);
    }

    public <T> T getAndRemoveOrResolveReferenceParameter(Map<String, Object> parameters, String key, Class<T> type) {
        return this.getAndRemoveOrResolveReferenceParameter(parameters, key, type, null);
    }

    public <T> T getAndRemoveOrResolveReferenceParameter(Map<String, Object> parameters, String key, Class<T> type, T defaultValue) {
        String str;
        Object value = parameters.remove(key);
        if (value instanceof String && EndpointHelper.isReferenceParameter(str = (String)value)) {
            return EndpointHelper.resolveReferenceParameter(this.getCamelContext(), str, type);
        }
        if (type.isInstance(value)) {
            if (String.class == type && EndpointHelper.isReferenceParameter(str = value.toString())) {
                value = EndpointHelper.resolveReferenceParameter(this.getCamelContext(), str, type);
            }
            return type.cast(value);
        }
        if (value == null) {
            return defaultValue;
        }
        str = (String)this.getCamelContext().getTypeConverter().tryConvertTo(String.class, value);
        if (EndpointHelper.isReferenceParameter(str)) {
            return EndpointHelper.resolveReferenceParameter(this.getCamelContext(), str, type);
        }
        return (T)this.getCamelContext().getTypeConverter().convertTo(type, value);
    }

    public <T> T resolveAndRemoveReferenceParameter(Map<String, Object> parameters, String key, Class<T> type) {
        return this.resolveAndRemoveReferenceParameter(parameters, key, type, null);
    }

    public <T> T resolveAndRemoveReferenceParameter(Map<String, Object> parameters, String key, Class<T> type, T defaultValue) {
        String str;
        Object value = parameters.remove(key);
        if (value instanceof String && EndpointHelper.isReferenceParameter(str = (String)value)) {
            return EndpointHelper.resolveReferenceParameter(this.getCamelContext(), str, type);
        }
        if (type.isInstance(value)) {
            if (String.class == type && EndpointHelper.isReferenceParameter(str = value.toString())) {
                value = EndpointHelper.resolveReferenceParameter(this.getCamelContext(), str, type);
            }
            return type.cast(value);
        }
        if (value == null) {
            return defaultValue;
        }
        str = (String)this.getCamelContext().getTypeConverter().tryConvertTo(String.class, value);
        return EndpointHelper.resolveReferenceParameter(this.getCamelContext(), str, type);
    }

    public <T> List<T> resolveAndRemoveReferenceListParameter(Map<String, Object> parameters, String key, Class<T> elementType) {
        return this.resolveAndRemoveReferenceListParameter(parameters, key, elementType, new ArrayList(0));
    }

    public <T> List<T> resolveAndRemoveReferenceListParameter(Map<String, Object> parameters, String key, Class<T> elementType, List<T> defaultValue) {
        Object value = this.getAndRemoveParameter(parameters, key, Object.class);
        if (value instanceof List) {
            return (List)value;
        }
        if (value == null) {
            return defaultValue;
        }
        String str = (String)this.getCamelContext().getTypeConverter().tryConvertTo(String.class, value);
        return EndpointHelper.resolveReferenceListParameter(this.getCamelContext(), str, elementType);
    }

    protected String ifStartsWithReturnRemainder(String prefix, String text) {
        String remainder;
        if (text.startsWith(prefix) && (remainder = text.substring(prefix.length())).length() > 0) {
            return remainder;
        }
        return null;
    }

    protected void registerExtension(ComponentExtension extension) {
        this.extensions.add(() -> extension);
    }

    protected void registerExtension(Supplier<ComponentExtension> supplier) {
        this.extensions.add(Suppliers.memorize(supplier));
    }

    public Collection<Class<? extends ComponentExtension>> getSupportedExtensions() {
        return this.extensions.stream().map(Supplier::get).map(Object::getClass).collect(Collectors.toList());
    }

    public <T extends ComponentExtension> Optional<T> getExtension(Class<T> extensionType) {
        return this.extensions.stream().map(Supplier::get).filter(extensionType::isInstance).findFirst().map(extensionType::cast).map(e -> (ComponentExtension)Component.trySetComponent((Object)e, (Component)this)).map(e -> (ComponentExtension)CamelContextAware.trySetCamelContext((Object)e, (CamelContext)this.getCamelContext()));
    }
}

