/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor;

import java.io.Closeable;
import java.util.Iterator;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.Traceable;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

public class UnmarshalProcessor
extends AsyncProcessorSupport
implements Traceable,
CamelContextAware,
IdAware,
RouteIdAware {
    private String id;
    private String routeId;
    private CamelContext camelContext;
    private final DataFormat dataFormat;
    private final boolean allowNullBody;
    private String variableSend;
    private String variableReceive;

    public UnmarshalProcessor(DataFormat dataFormat) {
        this(dataFormat, false);
    }

    public UnmarshalProcessor(DataFormat dataFormat, boolean allowNullBody) {
        this.dataFormat = dataFormat;
        this.allowNullBody = allowNullBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        ObjectHelper.notNull((Object)this.dataFormat, (String)"dataFormat");
        Closeable stream = null;
        Object result = null;
        try {
            Message out;
            Object originalBody;
            Message in = exchange.getIn();
            Object body = originalBody = in.getBody();
            if (this.variableSend != null) {
                body = ExchangeHelper.getVariable(exchange, this.variableSend);
            }
            if (this.allowNullBody && body == null) {
                out = exchange.getOut();
            } else {
                out = exchange.getOut();
                out.copyFrom(in);
                result = this.dataFormat.unmarshal(exchange, body);
            }
            if (result instanceof Exchange) {
                if (result != exchange) {
                    throw new RuntimeCamelException("The returned exchange " + result + " is not the same as " + exchange + " provided to the DataFormat");
                }
            } else if (result instanceof Message) {
                Message msg = (Message)result;
                if (this.variableReceive != null) {
                    Object value = msg.getBody();
                    ExchangeHelper.setVariable(exchange, this.variableReceive, value);
                } else {
                    exchange.setOut(msg);
                }
            } else if (this.variableReceive != null) {
                ExchangeHelper.setVariable(exchange, this.variableReceive, result);
            } else {
                out.setBody(result);
            }
        }
        catch (Exception e) {
            exchange.setOut(null);
            exchange.setException((Throwable)e);
        }
        finally {
            if (!(result instanceof Iterator)) {
                IOHelper.close(stream, (String)"input stream");
            }
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return "Unmarshal[" + this.dataFormat + "]";
    }

    public String getTraceLabel() {
        return "unmarshal[" + this.dataFormat + "]";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public boolean isAllowNullBody() {
        return this.allowNullBody;
    }

    public String getVariableSend() {
        return this.variableSend;
    }

    public void setVariableSend(String variableSend) {
        this.variableSend = variableSend;
    }

    public String getVariableReceive() {
        return this.variableReceive;
    }

    public void setVariableReceive(String variableReceive) {
        this.variableReceive = variableReceive;
    }

    protected void doStart() throws Exception {
        CamelContextAware.trySetCamelContext((Object)this.dataFormat, (CamelContext)this.camelContext);
        this.getCamelContext().addService((Object)this.dataFormat, false, true);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Service)this.dataFormat);
        this.getCamelContext().removeService((Object)this.dataFormat);
    }
}

