/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.WrappedFile;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExchangeHolder
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultExchangeHolder.class);
    private String exchangeId;
    private Object inBody;
    private Object outBody;
    private Map<String, Object> inHeaders;
    private Map<String, Object> outHeaders;
    private Map<String, Object> properties;
    private Exception exception;

    public static DefaultExchangeHolder marshal(Exchange exchange) {
        return DefaultExchangeHolder.marshal(exchange, true, false);
    }

    public static DefaultExchangeHolder marshal(Exchange exchange, boolean includeProperties) {
        return DefaultExchangeHolder.marshal(exchange, includeProperties, false, true);
    }

    public static DefaultExchangeHolder marshal(Exchange exchange, boolean includeProperties, boolean allowSerializedHeaders) {
        return DefaultExchangeHolder.marshal(exchange, includeProperties, allowSerializedHeaders, true);
    }

    public static DefaultExchangeHolder marshal(Exchange exchange, boolean includeProperties, boolean allowSerializedHeaders, boolean preserveExchangeId) {
        ObjectHelper.notNull((Object)exchange, (String)"exchange");
        Object body = exchange.getIn().getBody();
        if (body instanceof WrappedFile || body instanceof File) {
            throw new RuntimeExchangeException("Message body of type " + body.getClass().getCanonicalName() + " is not supported by this marshaller.", exchange);
        }
        DefaultExchangeHolder payload = new DefaultExchangeHolder();
        if (preserveExchangeId) {
            payload.exchangeId = exchange.getExchangeId();
        }
        payload.inBody = DefaultExchangeHolder.checkSerializableBody("in body", exchange, exchange.getIn().getBody());
        payload.safeSetInHeaders(exchange, allowSerializedHeaders);
        if (exchange.hasOut()) {
            payload.outBody = DefaultExchangeHolder.checkSerializableBody("out body", exchange, exchange.getOut().getBody());
            payload.safeSetOutHeaders(exchange, allowSerializedHeaders);
        }
        if (includeProperties) {
            payload.safeSetProperties(exchange, allowSerializedHeaders);
        }
        payload.exception = exchange.getException();
        return payload;
    }

    public static void unmarshal(Exchange exchange, DefaultExchangeHolder payload) {
        ObjectHelper.notNull((Object)exchange, (String)"exchange");
        ObjectHelper.notNull((Object)payload, (String)"payload");
        if (payload.exchangeId != null) {
            exchange.setExchangeId(payload.exchangeId);
        }
        exchange.getIn().setBody(payload.inBody);
        if (payload.inHeaders != null) {
            exchange.getIn().setHeaders(payload.inHeaders);
        }
        if (payload.outBody != null) {
            exchange.getOut().setBody(payload.outBody);
            if (payload.outHeaders != null) {
                exchange.getOut().setHeaders(payload.outHeaders);
            }
        }
        if (payload.properties != null) {
            for (Map.Entry<String, Object> entry : payload.properties.entrySet()) {
                exchange.setProperty(entry.getKey(), entry.getValue());
            }
        }
        exchange.setException((Throwable)payload.exception);
    }

    public static void addProperty(DefaultExchangeHolder payload, String key, Serializable property) {
        if (key == null || property == null) {
            return;
        }
        if (payload.properties == null) {
            payload.properties = new LinkedHashMap<String, Object>();
        }
        payload.properties.put(key, property);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultExchangeHolder[exchangeId=").append(this.exchangeId);
        sb.append("inBody=").append(this.inBody).append(", outBody=").append(this.outBody);
        sb.append(", inHeaders=").append(this.inHeaders).append(", outHeaders=").append(this.outHeaders);
        sb.append(", properties=").append(this.properties).append(", exception=").append(this.exception);
        return sb.append(']').toString();
    }

    private Map<String, Object> safeSetInHeaders(Exchange exchange, boolean allowSerializedHeaders) {
        Map<String, Object> map;
        if (exchange.getIn().hasHeaders() && (map = DefaultExchangeHolder.checkValidHeaderObjects("in headers", exchange, exchange.getIn().getHeaders(), allowSerializedHeaders)) != null && !map.isEmpty()) {
            this.inHeaders = new LinkedHashMap<String, Object>(map);
        }
        return null;
    }

    @Deprecated(since="3.0.0")
    private Map<String, Object> safeSetOutHeaders(Exchange exchange, boolean allowSerializedHeaders) {
        Map<String, Object> map;
        if (exchange.hasOut() && exchange.getOut().hasHeaders() && (map = DefaultExchangeHolder.checkValidHeaderObjects("out headers", exchange, exchange.getOut().getHeaders(), allowSerializedHeaders)) != null && !map.isEmpty()) {
            this.outHeaders = new LinkedHashMap<String, Object>(map);
        }
        return null;
    }

    private Map<String, Object> safeSetProperties(Exchange exchange, boolean allowSerializedHeaders) {
        Map<String, Object> map = DefaultExchangeHolder.checkValidExchangePropertyObjects("properties", exchange, exchange.getAllProperties(), allowSerializedHeaders);
        if (map != null && !map.isEmpty()) {
            this.properties = new LinkedHashMap<String, Object>(map);
        }
        return null;
    }

    private static Object checkSerializableBody(String type, Exchange exchange, Object object) {
        if (object == null) {
            return null;
        }
        Serializable converted = (Serializable)exchange.getContext().getTypeConverter().convertTo(Serializable.class, exchange, object);
        if (converted != null) {
            return converted;
        }
        LOG.warn("Exchange {} containing object: {} of type: {} cannot be serialized, it will be excluded by the holder.", new Object[]{type, object, object.getClass().getCanonicalName()});
        return null;
    }

    private static Map<String, Object> checkValidHeaderObjects(String type, Exchange exchange, Map<String, Object> map, boolean allowSerializedHeaders) {
        if (map == null) {
            return null;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            Object value = DefaultExchangeHolder.getValidHeaderValue(entry.getKey(), entry.getValue(), allowSerializedHeaders);
            if (value != null) {
                Serializable converted = (Serializable)exchange.getContext().getTypeConverter().convertTo(Serializable.class, exchange, value);
                if (converted != null) {
                    result.put(entry.getKey(), converted);
                    continue;
                }
                DefaultExchangeHolder.logCannotSerializeObject(type, entry.getKey(), entry.getValue());
                continue;
            }
            DefaultExchangeHolder.logInvalidHeaderValue(type, entry.getKey(), entry.getValue());
        }
        return result;
    }

    private static Map<String, Object> checkValidExchangePropertyObjects(String type, Exchange exchange, Map<String, Object> map, boolean allowSerializedHeaders) {
        if (map == null) {
            return null;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            Object value = DefaultExchangeHolder.getValidExchangePropertyValue(entry.getKey(), entry.getValue(), allowSerializedHeaders);
            if (value != null) {
                Serializable converted = (Serializable)exchange.getContext().getTypeConverter().convertTo(Serializable.class, exchange, value);
                if (converted != null) {
                    result.put(entry.getKey(), converted);
                    continue;
                }
                DefaultExchangeHolder.logCannotSerializeObject(type, entry.getKey(), entry.getValue());
                continue;
            }
            DefaultExchangeHolder.logInvalidExchangePropertyValue(type, entry.getKey(), entry.getValue());
        }
        return result;
    }

    protected static Object getValidHeaderValue(String headerName, Object headerValue, boolean allowSerializedHeaders) {
        if (headerValue instanceof String) {
            return headerValue;
        }
        if (headerValue instanceof BigInteger) {
            return headerValue;
        }
        if (headerValue instanceof BigDecimal) {
            return headerValue;
        }
        if (headerValue instanceof Number) {
            return headerValue;
        }
        if (headerValue instanceof Character) {
            return headerValue;
        }
        if (headerValue instanceof CharSequence) {
            return headerValue.toString();
        }
        if (headerValue instanceof Boolean) {
            return headerValue;
        }
        if (headerValue instanceof Date) {
            return headerValue;
        }
        if (allowSerializedHeaders && headerValue instanceof Serializable) {
            return headerValue;
        }
        return null;
    }

    protected static Object getValidExchangePropertyValue(String propertyName, Object propertyValue, boolean allowSerializedHeaders) {
        if (propertyValue instanceof Throwable) {
            return propertyValue;
        }
        return DefaultExchangeHolder.getValidHeaderValue(propertyName, propertyValue, allowSerializedHeaders);
    }

    private static void logCannotSerializeObject(String type, String key, Object value) {
        if (key.startsWith("Camel")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Exchange {} containing key: {} with object: {} of type: {} cannot be serialized, it will be excluded by the holder.", new Object[]{type, key, value, ObjectHelper.classCanonicalName((Object)value)});
            }
        } else {
            LOG.warn("Exchange {} containing key: {} with object: {} of type: {} cannot be serialized, it will be excluded by the holder.", new Object[]{type, key, value, ObjectHelper.classCanonicalName((Object)value)});
        }
    }

    private static void logInvalidHeaderValue(String type, String key, Object value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exchange {} containing key: {} with object: {} of type: {} is not valid header type, it will be excluded by the holder.", new Object[]{type, key, value, ObjectHelper.classCanonicalName((Object)value)});
        }
    }

    private static void logInvalidExchangePropertyValue(String type, String key, Object value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exchange {} containing key: {} with object: {} of type: {} is not valid exchange property type, it will be excluded by the holder.", new Object[]{type, key, value, ObjectHelper.classCanonicalName((Object)value)});
        }
    }
}

