/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.task;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.apache.camel.support.task.AbstractTaskBuilder;
import org.apache.camel.support.task.BlockingTask;
import org.apache.camel.support.task.budget.TimeBudget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundTask
implements BlockingTask {
    private static final Logger LOG = LoggerFactory.getLogger(BackgroundTask.class);
    private final TimeBudget budget;
    private final ScheduledExecutorService service;
    private final String name;
    private final CountDownLatch latch = new CountDownLatch(1);
    private Duration elapsed = Duration.ZERO;
    private boolean completed;

    BackgroundTask(TimeBudget budget, ScheduledExecutorService service, String name) {
        this.budget = budget;
        this.service = Objects.requireNonNull(service);
        this.name = name;
    }

    private void runTaskWrapper(BooleanSupplier supplier) {
        LOG.trace("Current latch value: {}", (Object)this.latch.getCount());
        if (this.latch.getCount() == 0L) {
            return;
        }
        if (!this.budget.next()) {
            LOG.warn("The task {} does not have more budget to continue running", (Object)this.name);
            this.completed = false;
            this.latch.countDown();
            return;
        }
        if (supplier.getAsBoolean()) {
            this.completed = true;
            this.latch.countDown();
            LOG.trace("Task {} succeeded and the current task won't be schedulable anymore: {}", (Object)this.name, (Object)this.latch.getCount());
        }
    }

    @Override
    public boolean run(BooleanSupplier supplier) {
        ScheduledFuture<?> task = this.service.scheduleAtFixedRate(() -> this.runTaskWrapper(supplier), this.budget.initialDelay(), this.budget.interval(), TimeUnit.MILLISECONDS);
        this.waitForTaskCompletion(task);
        return this.completed;
    }

    private void waitForTaskCompletion(Future<?> task) {
        try {
            if (this.budget.maxDuration() == -1L) {
                this.latch.await();
            } else if (!this.latch.await(this.budget.maxDuration(), TimeUnit.MILLISECONDS)) {
                LOG.debug("Timeout out waiting for the completion of the task");
            } else {
                LOG.debug("The task has finished the execution and it is ready to continue");
            }
            task.cancel(true);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting for the repeatable task to execute: {}", (Object)e.getMessage(), (Object)e);
            Thread.currentThread().interrupt();
        }
        finally {
            this.elapsed = this.budget.elapsed();
        }
    }

    @Override
    public Duration elapsed() {
        return this.elapsed;
    }

    public static class BackgroundTaskBuilder
    extends AbstractTaskBuilder<BackgroundTask> {
        private TimeBudget budget;
        private ScheduledExecutorService service;

        public BackgroundTaskBuilder withBudget(TimeBudget timeBudget) {
            this.budget = timeBudget;
            return this;
        }

        public BackgroundTaskBuilder withScheduledExecutor(ScheduledExecutorService service) {
            this.service = service;
            return this;
        }

        @Override
        public BackgroundTask build() {
            return new BackgroundTask(this.budget, this.service, this.getName());
        }
    }
}

