/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.support.LRUCacheFactory;

public class DefaultEndpointUtilizationStatistics
implements EndpointUtilizationStatistics {
    private final int maxCapacity;
    private final Map<String, Long> map;
    private final Lock lock = new ReentrantLock();

    public DefaultEndpointUtilizationStatistics(int maxCapacity) {
        this.map = LRUCacheFactory.newLRUCache(16, maxCapacity, false);
        this.maxCapacity = maxCapacity;
    }

    public int maxCapacity() {
        return this.maxCapacity;
    }

    public int size() {
        return this.map.size();
    }

    public void onHit(String uri) {
        this.lock.lock();
        try {
            this.map.compute(uri, (key, current) -> {
                if (current == null) {
                    return 1L;
                }
                current = current + 1L;
                return current;
            });
        }
        finally {
            this.lock.unlock();
        }
    }

    public void remove(String uri) {
        this.map.remove(uri);
    }

    public Map<String, Long> getStatistics() {
        return Collections.unmodifiableMap(this.map);
    }

    public void clear() {
        this.map.clear();
    }
}

