/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.generator.swagger;

import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.Property;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.generator.swagger.CodeEmitter;
import org.apache.camel.generator.swagger.DestinationGenerator;
import org.apache.camel.generator.swagger.OperationFilter;
import org.apache.camel.model.rest.CollectionFormat;
import org.apache.camel.model.rest.RestParamType;
import org.apache.camel.util.ObjectHelper;

class OperationVisitor<T> {
    private final DestinationGenerator destinationGenerator;
    private final CodeEmitter<T> emitter;
    private final OperationFilter filter;
    private final String path;

    OperationVisitor(CodeEmitter<T> emitter, OperationFilter filter, String path, DestinationGenerator destinationGenerator) {
        this.emitter = emitter;
        this.filter = filter;
        this.path = path;
        this.destinationGenerator = destinationGenerator;
    }

    List<String> asStringList(List<?> values) {
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> stringList = new ArrayList<String>();
        values.forEach(v -> stringList.add(String.valueOf(v)));
        return stringList;
    }

    CodeEmitter<T> emit(Parameter parameter) {
        this.emitter.emit("param", new Object[0]);
        this.emit("name", parameter.getName());
        String parameterType = parameter.getIn();
        if (ObjectHelper.isNotEmpty((String)parameterType)) {
            this.emit("type", RestParamType.valueOf((String)parameterType));
        }
        if (parameter instanceof AbstractSerializableParameter) {
            AbstractSerializableParameter serializableParameter = (AbstractSerializableParameter)parameter;
            String dataType = serializableParameter.getType();
            this.emit("dataType", dataType);
            this.emit("allowableValues", this.asStringList(serializableParameter.getEnumValue()));
            String collectionFormat = serializableParameter.getCollectionFormat();
            if (ObjectHelper.isNotEmpty((String)collectionFormat)) {
                this.emit("collectionFormat", CollectionFormat.valueOf((String)collectionFormat));
            }
            if (ObjectHelper.isNotEmpty((Object)serializableParameter.getDefault())) {
                String value = serializableParameter.getDefault().toString();
                this.emit("defaultValue", value);
            }
            Property items = serializableParameter.getItems();
            if ("array".equals(dataType) && items != null) {
                this.emit("arrayType", items.getType());
            }
        }
        this.emit("required", parameter.getRequired());
        this.emit("description", parameter.getDescription());
        this.emitter.emit("endParam", new Object[0]);
        return this.emitter;
    }

    CodeEmitter<T> emit(String method, List<String> values) {
        if (values == null || values.isEmpty()) {
            return this.emitter;
        }
        return this.emitter.emit(method, new Object[]{values.toArray(new String[values.size()])});
    }

    CodeEmitter<T> emit(String method, Object value) {
        if (ObjectHelper.isEmpty((Object)value)) {
            return this.emitter;
        }
        return this.emitter.emit(method, value);
    }

    void visit(HttpMethod method, Operation operation) {
        if (this.filter.accept(operation.getOperationId())) {
            String methodName = method.name().toLowerCase();
            this.emitter.emit(methodName, this.path);
            this.emit("id", operation.getOperationId());
            this.emit("description", operation.getDescription());
            this.emit("consumes", operation.getConsumes());
            this.emit("produces", operation.getProduces());
            operation.getParameters().forEach(parameter -> this.emit((Parameter)parameter));
            this.emitter.emit("to", this.destinationGenerator.generateDestinationFor(operation));
        }
    }
}

