/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.generator.swagger;

import io.swagger.models.Swagger;
import java.nio.file.Path;
import javax.annotation.processing.Filer;
import org.apache.camel.generator.swagger.AppendableGenerator;
import org.apache.camel.generator.swagger.DestinationGenerator;
import org.apache.camel.generator.swagger.DirectToOperationId;
import org.apache.camel.generator.swagger.FilerGenerator;
import org.apache.camel.generator.swagger.OperationFilter;
import org.apache.camel.generator.swagger.PathGenerator;
import org.apache.camel.generator.swagger.RestDslDefinitionGenerator;
import org.apache.camel.generator.swagger.RestDslSourceCodeGenerator;
import org.apache.camel.generator.swagger.RestDslXmlGenerator;
import org.apache.camel.util.ObjectHelper;

public abstract class RestDslGenerator<G> {
    final Swagger swagger;
    DestinationGenerator destinationGenerator = new DirectToOperationId();
    OperationFilter filter = new OperationFilter();
    String restComponent;
    String restContextPath;
    String apiContextPath;
    boolean clientRequestValidation;
    boolean springComponent;
    boolean springBootProject;

    RestDslGenerator(Swagger swagger) {
        this.swagger = (Swagger)ObjectHelper.notNull((Object)swagger, (String)"swagger");
    }

    public G withDestinationGenerator(DestinationGenerator directRouteGenerator) {
        ObjectHelper.notNull((Object)directRouteGenerator, (String)"directRouteGenerator");
        this.destinationGenerator = directRouteGenerator;
        RestDslGenerator that = this;
        return (G)that;
    }

    DestinationGenerator destinationGenerator() {
        return this.destinationGenerator;
    }

    public G withOperationFilter(OperationFilter filter) {
        this.filter = filter;
        RestDslGenerator that = this;
        return (G)that;
    }

    public G withOperationFilter(String include) {
        this.filter.setIncludes(include);
        RestDslGenerator that = this;
        return (G)that;
    }

    public G withRestComponent(String restComponent) {
        this.restComponent = restComponent;
        RestDslGenerator that = this;
        return (G)that;
    }

    public G withRestContextPath(String contextPath) {
        this.restContextPath = contextPath;
        RestDslGenerator that = this;
        return (G)that;
    }

    public G withApiContextPath(String contextPath) {
        this.apiContextPath = contextPath;
        RestDslGenerator that = this;
        return (G)that;
    }

    public G withClientRequestValidation() {
        this.clientRequestValidation = true;
        RestDslGenerator that = this;
        return (G)that;
    }

    public G asSpringComponent() {
        this.springComponent = true;
        RestDslGenerator that = this;
        return (G)that;
    }

    public G asSpringBootProject() {
        this.springBootProject = true;
        RestDslGenerator that = this;
        return (G)that;
    }

    public static RestDslSourceCodeGenerator<Appendable> toAppendable(Swagger swagger) {
        return new AppendableGenerator(swagger);
    }

    public static RestDslDefinitionGenerator toDefinition(Swagger swagger) {
        return new RestDslDefinitionGenerator(swagger);
    }

    public static RestDslXmlGenerator toXml(Swagger swagger) {
        return new RestDslXmlGenerator(swagger);
    }

    public static RestDslSourceCodeGenerator<Filer> toFiler(Swagger swagger) {
        return new FilerGenerator(swagger);
    }

    public static RestDslSourceCodeGenerator<Path> toPath(Swagger swagger) {
        return new PathGenerator(swagger);
    }
}

