/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.telegram.TelegramConfiguration;
import org.apache.camel.component.telegram.TelegramEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ObjectHelper;

public class TelegramComponent
extends UriEndpointComponent {
    @Metadata(label="security")
    private String authorizationToken;

    public TelegramComponent() {
        super(TelegramEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        TelegramConfiguration configuration = new TelegramConfiguration();
        this.setProperties(configuration, parameters);
        if (ObjectHelper.isNotEmpty((Object)remaining)) {
            configuration.updatePathConfig(remaining, this.getAuthorizationToken());
        }
        if ("bots".equals(configuration.getType())) {
            return new TelegramEndpoint(uri, (Component)this, configuration);
        }
        throw new IllegalArgumentException("Unsupported endpoint type for uri " + uri + ", remaining " + remaining);
    }

    public String getAuthorizationToken() {
        return this.authorizationToken;
    }

    public void setAuthorizationToken(String authorizationToken) {
        this.authorizationToken = authorizationToken;
    }
}

