/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.camel.component.telegram.model.InlineKeyboardMarkup;
import org.apache.camel.component.telegram.model.InlineQueryResult;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class InlineQueryResultGame
extends InlineQueryResult {
    private static final String TYPE = "game";
    @JsonProperty(value="game_short_name")
    private String gameShortName;

    public InlineQueryResultGame() {
        super(TYPE);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private InlineKeyboardMarkup replyMarkup;
        private String gameShortName;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public Builder gameShortName(String gameShortName) {
            this.gameShortName = gameShortName;
            return this;
        }

        public InlineQueryResultGame build() {
            InlineQueryResultGame inlineQueryResultGame = new InlineQueryResultGame();
            inlineQueryResultGame.setType(InlineQueryResultGame.TYPE);
            inlineQueryResultGame.setId(this.id);
            inlineQueryResultGame.setReplyMarkup(this.replyMarkup);
            inlineQueryResultGame.gameShortName = this.gameShortName;
            return inlineQueryResultGame;
        }

        public String getId() {
            return this.id;
        }

        public InlineKeyboardMarkup getReplyMarkup() {
            return this.replyMarkup;
        }

        public String getGameShortName() {
            return this.gameShortName;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
        }

        public void setGameShortName(String gameShortName) {
            this.gameShortName = gameShortName;
        }
    }
}

