/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.tensorflow.serving;

import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.Grpc;
import io.grpc.InsecureChannelCredentials;
import io.grpc.ManagedChannel;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.tensorflow.serving.TensorFlowServingComponent;
import org.apache.camel.component.tensorflow.serving.TensorFlowServingConfiguration;
import org.apache.camel.component.tensorflow.serving.TensorFlowServingConstants;
import org.apache.camel.component.tensorflow.serving.TensorFlowServingProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import tensorflow.serving.ModelServiceGrpc;
import tensorflow.serving.PredictionServiceGrpc;

@UriEndpoint(firstVersion="4.10.0", scheme="tensorflow-serving", title="TensorFlow Serving", syntax="tensorflow-serving:api", producerOnly=true, category={Category.AI}, headersClass=TensorFlowServingConstants.class)
public class TensorFlowServingEndpoint
extends DefaultEndpoint {
    @UriPath(enums="model-status,model-metadata,classify,regress,predict", description="The TensorFlow Serving API")
    @Metadata(required=true)
    private final String api;
    @UriParam
    private TensorFlowServingConfiguration configuration;
    private ManagedChannel channel;
    private ModelServiceGrpc.ModelServiceBlockingStub modelService;
    private PredictionServiceGrpc.PredictionServiceBlockingStub predictionService;

    public TensorFlowServingEndpoint(String uri, TensorFlowServingComponent component, String path, TensorFlowServingConfiguration configuration) {
        super(uri, (Component)component);
        this.api = path;
        this.configuration = configuration;
    }

    protected void doInit() throws Exception {
        super.doInit();
        ChannelCredentials credentials = this.configuration.getCredentials() != null ? this.configuration.getCredentials() : InsecureChannelCredentials.create();
        this.channel = Grpc.newChannelBuilder((String)this.configuration.getTarget(), (ChannelCredentials)credentials).build();
        this.modelService = ModelServiceGrpc.newBlockingStub((Channel)this.channel);
        this.predictionService = PredictionServiceGrpc.newBlockingStub((Channel)this.channel);
    }

    public void doStop() throws Exception {
        super.doStop();
        this.channel.shutdown();
    }

    public Producer createProducer() {
        return new TensorFlowServingProducer(this);
    }

    public Consumer createConsumer(Processor processor) {
        throw new UnsupportedOperationException("Consumer not supported");
    }

    public String getApi() {
        return this.api;
    }

    public TensorFlowServingConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(TensorFlowServingConfiguration configuration) {
        this.configuration = configuration;
    }

    public ModelServiceGrpc.ModelServiceBlockingStub getModelService() {
        return this.modelService;
    }

    public PredictionServiceGrpc.PredictionServiceBlockingStub getPredictionService() {
        return this.predictionService;
    }
}

