/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.activemq.common;

import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.camel.test.infra.activemq.services.AbstractActiveMQEmbeddedService;
import org.apache.camel.test.infra.activemq.services.ActiveMQService;
import org.apache.camel.test.infra.activemq.services.ActiveMQServiceFactory;
import org.apache.camel.test.infra.activemq.services.ConnectionFactoryAware;

public final class ConnectionFactoryHelper {
    private ConnectionFactoryHelper() {
    }

    public static ConnectionFactory createConnectionFactory(ActiveMQService service) {
        return ConnectionFactoryHelper.createConnectionFactory(service, null);
    }

    public static ConnectionFactory createConnectionFactory(ActiveMQService service, Integer maximumRedeliveries) {
        if (service instanceof ConnectionFactoryAware) {
            return ConnectionFactoryHelper.createConnectionFactory(((AbstractActiveMQEmbeddedService)service).getVmURL(), maximumRedeliveries);
        }
        if (service instanceof ActiveMQServiceFactory.SingletonActiveMQService) {
            return ConnectionFactoryHelper.createConnectionFactory(((ActiveMQServiceFactory.SingletonActiveMQService)service).getService(), maximumRedeliveries);
        }
        throw new UnsupportedOperationException("The test service does not implement ConnectionFactoryAware");
    }

    public static ConnectionFactory createConnectionFactory(String url, Integer maximumRedeliveries) {
        return ConnectionFactoryHelper.createConnectionFactory(new ActiveMQConnectionFactory(url), maximumRedeliveries);
    }

    public static ConnectionFactory createConnectionFactory(ActiveMQConnectionFactory connectionFactory, Integer maximumRedeliveries) {
        connectionFactory.setCopyMessageOnSend(false);
        connectionFactory.setOptimizeAcknowledge(true);
        connectionFactory.setOptimizedMessageDispatch(true);
        connectionFactory.setUseAsyncSend(false);
        connectionFactory.setAlwaysSessionAsync(false);
        if (maximumRedeliveries != null) {
            connectionFactory.getRedeliveryPolicy().setMaximumRedeliveries(maximumRedeliveries.intValue());
        }
        connectionFactory.setTrustAllPackages(true);
        connectionFactory.setWatchTopicAdvisories(false);
        return connectionFactory;
    }

    public static ConnectionFactory createPersistentConnectionFactory(String url) {
        return ConnectionFactoryHelper.createPersistentConnectionFactory(new ActiveMQConnectionFactory(url));
    }

    public static ConnectionFactory createPersistentConnectionFactory(ActiveMQConnectionFactory connectionFactory) {
        connectionFactory.setCopyMessageOnSend(false);
        connectionFactory.setOptimizeAcknowledge(true);
        connectionFactory.setOptimizedMessageDispatch(true);
        connectionFactory.setAlwaysSessionAsync(false);
        connectionFactory.setTrustAllPackages(true);
        return connectionFactory;
    }
}

