/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.activemq.services;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import javax.management.ObjectName;
import org.apache.activemq.Service;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerContext;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.SslContext;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.BrokerView;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.broker.region.DestinationFactory;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.scheduler.JobSchedulerStore;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.network.jms.JmsConnector;
import org.apache.activemq.security.MessageAuthorizationPolicy;
import org.apache.activemq.store.PListStore;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.PersistenceAdapterFactory;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.util.IOExceptionHandler;
import org.apache.camel.test.infra.activemq.services.ActiveMQEmbeddedService;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ActiveMQEmbeddedServiceBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveMQEmbeddedServiceBuilder.class);
    private static final LongAdder BROKER_COUNT = new LongAdder();
    private final BrokerService brokerService = new BrokerService();

    private ActiveMQEmbeddedServiceBuilder() {
    }

    public ActiveMQEmbeddedServiceBuilder withAdminView(BrokerView adminView) {
        this.brokerService.setAdminView(adminView);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withBrokerName(Class<?> testClass) {
        return this.withBrokerName(testClass.getSimpleName());
    }

    public ActiveMQEmbeddedServiceBuilder withBrokerName(String brokerName) {
        this.brokerService.setBrokerName(brokerName);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withBrokerName(Class<?> testClass, String name) {
        return this.withBrokerName(testClass.getSimpleName(), name);
    }

    public ActiveMQEmbeddedServiceBuilder withBrokerName(String brokerName, String name) {
        this.brokerService.setBrokerName(brokerName + (String)(name != null ? "-" + name : ""));
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withDataDirectory(Path dataDirectory) {
        return this.withDataDirectory(dataDirectory.toAbsolutePath().toString());
    }

    public ActiveMQEmbeddedServiceBuilder withDataDirectory(String dataDirectory) {
        this.brokerService.setDataDirectory(dataDirectory);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withDataDirectoryFile(File dataDirectoryFile) {
        this.brokerService.setDataDirectoryFile(dataDirectoryFile);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withTmpDataDirectory(File tmpDataDirectory) {
        this.brokerService.setTmpDataDirectory(tmpDataDirectory);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withPersistenceFactory(PersistenceAdapterFactory persistenceFactory) {
        this.brokerService.setPersistenceFactory(persistenceFactory);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withDestinationFactory(DestinationFactory destinationFactory) {
        this.brokerService.setDestinationFactory(destinationFactory);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withPersistent(boolean persistent) {
        this.brokerService.setPersistent(persistent);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withPopulateJMSXUserID(boolean populateJMSXUserID) {
        this.brokerService.setPopulateJMSXUserID(populateJMSXUserID);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withSystemUsage(SystemUsage memoryManager) {
        this.brokerService.setSystemUsage(memoryManager);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withConsumerSystemUsage(SystemUsage consumerSystemUsage) {
        this.brokerService.setConsumerSystemUsage(consumerSystemUsage);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withProducerSystemUsage(SystemUsage producerUsageManager) {
        this.brokerService.setProducerSystemUsage(producerUsageManager);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withPersistenceAdapter(PersistenceAdapter persistenceAdapter) {
        try {
            this.brokerService.setPersistenceAdapter(persistenceAdapter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withTaskRunnerFactory(TaskRunnerFactory taskRunnerFactory) {
        this.brokerService.setTaskRunnerFactory(taskRunnerFactory);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withPersistenceTaskRunnerFactory(TaskRunnerFactory persistenceTaskRunnerFactory) {
        this.brokerService.setPersistenceTaskRunnerFactory(persistenceTaskRunnerFactory);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withEnableStatistics(boolean enableStatistics) {
        this.brokerService.setEnableStatistics(enableStatistics);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withUseJmx(boolean useJmx) {
        this.brokerService.setUseJmx(useJmx);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withBrokerObjectName(ObjectName brokerObjectName) {
        this.brokerService.setBrokerObjectName(brokerObjectName);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withManagementContext(ManagementContext managementContext) {
        this.brokerService.setManagementContext(managementContext);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withNetworkConnectorURIs(String[] networkConnectorURIs) {
        this.brokerService.setNetworkConnectorURIs(networkConnectorURIs);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withTransportConnectorURIs(String[] transportConnectorURIs) {
        this.brokerService.setTransportConnectorURIs(transportConnectorURIs);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withJmsBridgeConnectors(JmsConnector[] jmsConnectors) {
        this.brokerService.setJmsBridgeConnectors(jmsConnectors);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withServices(Service[] services) {
        this.brokerService.setServices(services);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withUseLoggingForShutdownErrors(boolean useLoggingForShutdownErrors) {
        this.brokerService.setUseLoggingForShutdownErrors(useLoggingForShutdownErrors);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withUseShutdownHook(boolean useShutdownHook) {
        this.brokerService.setUseShutdownHook(useShutdownHook);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withAdvisorySupport(boolean advisorySupport) {
        this.brokerService.setAdvisorySupport(advisorySupport);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withAnonymousProducerAdvisorySupport(boolean anonymousProducerAdvisorySupport) {
        this.brokerService.setAnonymousProducerAdvisorySupport(anonymousProducerAdvisorySupport);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withTransportConnectors(List<TransportConnector> transportConnectors) throws Exception {
        this.brokerService.setTransportConnectors(transportConnectors);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withNetworkConnectors(List<?> networkConnectors) throws Exception {
        this.brokerService.setNetworkConnectors(networkConnectors);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withProxyConnectors(List<?> proxyConnectors) throws Exception {
        this.brokerService.setProxyConnectors(proxyConnectors);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withDestinationPolicy(PolicyMap policyMap) {
        this.brokerService.setDestinationPolicy(policyMap);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withPlugins(BrokerPlugin[] plugins) {
        this.brokerService.setPlugins(plugins);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withMessageAuthorizationPolicy(MessageAuthorizationPolicy messageAuthorizationPolicy) {
        this.brokerService.setMessageAuthorizationPolicy(messageAuthorizationPolicy);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withDeleteAllMessagesOnStartup(boolean deletePersistentMessagesOnStartup) {
        this.brokerService.setDeleteAllMessagesOnStartup(deletePersistentMessagesOnStartup);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withVmConnectorURI(URI vmConnectorURI) {
        this.brokerService.setVmConnectorURI(vmConnectorURI);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withShutdownOnMasterFailure(boolean shutdownOnMasterFailure) {
        this.brokerService.setShutdownOnMasterFailure(shutdownOnMasterFailure);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withKeepDurableSubsActive(boolean keepDurableSubsActive) {
        this.brokerService.setKeepDurableSubsActive(keepDurableSubsActive);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withEnableMessageExpirationOnActiveDurableSubs(boolean enableMessageExpirationOnActiveDurableSubs) {
        this.brokerService.setEnableMessageExpirationOnActiveDurableSubs(enableMessageExpirationOnActiveDurableSubs);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withUseVirtualTopics(boolean useVirtualTopics) {
        this.brokerService.setUseVirtualTopics(useVirtualTopics);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withUseMirroredQueues(boolean useMirroredQueues) {
        this.brokerService.setUseMirroredQueues(useMirroredQueues);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withDestinationInterceptors(DestinationInterceptor[] destinationInterceptors) {
        this.brokerService.setDestinationInterceptors(destinationInterceptors);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withDestinations(ActiveMQDestination[] destinations) {
        this.brokerService.setDestinations(destinations);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withTempDataStore(PListStore tempDataStore) {
        this.brokerService.setTempDataStore(tempDataStore);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withPersistenceThreadPriority(int persistenceThreadPriority) {
        this.brokerService.setPersistenceThreadPriority(persistenceThreadPriority);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withUseLocalHostBrokerName(boolean useLocalHostBrokerName) {
        this.brokerService.setUseLocalHostBrokerName(useLocalHostBrokerName);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withProducerSystemUsagePortion(int producerSystemUsagePortion) {
        this.brokerService.setProducerSystemUsagePortion(producerSystemUsagePortion);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withConsumerSystemUsagePortion(int consumerSystemUsagePortion) {
        this.brokerService.setConsumerSystemUsagePortion(consumerSystemUsagePortion);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withSplitSystemUsageForProducersConsumers(boolean splitSystemUsageForProducersConsumers) {
        this.brokerService.setSplitSystemUsageForProducersConsumers(splitSystemUsageForProducersConsumers);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withMonitorConnectionSplits(boolean monitorConnectionSplits) {
        this.brokerService.setMonitorConnectionSplits(monitorConnectionSplits);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withTaskRunnerPriority(int taskRunnerPriority) {
        this.brokerService.setTaskRunnerPriority(taskRunnerPriority);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withDedicatedTaskRunner(boolean dedicatedTaskRunner) {
        this.brokerService.setDedicatedTaskRunner(dedicatedTaskRunner);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withCacheTempDestinations(boolean cacheTempDestinations) {
        this.brokerService.setCacheTempDestinations(cacheTempDestinations);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withTimeBeforePurgeTempDestinations(int timeBeforePurgeTempDestinations) {
        this.brokerService.setTimeBeforePurgeTempDestinations(timeBeforePurgeTempDestinations);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withUseTempMirroredQueues(boolean useTempMirroredQueues) {
        this.brokerService.setUseTempMirroredQueues(useTempMirroredQueues);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withJobSchedulerStore(JobSchedulerStore jobSchedulerStore) {
        this.brokerService.setJobSchedulerStore(jobSchedulerStore);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withShutdownHooks(List<Runnable> hooks) throws Exception {
        this.brokerService.setShutdownHooks(hooks);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withRegionBroker(Broker regionBroker) {
        this.brokerService.setRegionBroker(regionBroker);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withSystemExitOnShutdown(boolean systemExitOnShutdown) {
        this.brokerService.setSystemExitOnShutdown(systemExitOnShutdown);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withSystemExitOnShutdownExitCode(int systemExitOnShutdownExitCode) {
        this.brokerService.setSystemExitOnShutdownExitCode(systemExitOnShutdownExitCode);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withSslContext(SslContext sslContext) {
        this.brokerService.setSslContext(sslContext);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withShutdownOnSlaveFailure(boolean shutdownOnSlaveFailure) {
        this.brokerService.setShutdownOnSlaveFailure(shutdownOnSlaveFailure);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withWaitForSlave(boolean waitForSlave) {
        this.brokerService.setWaitForSlave(waitForSlave);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withWaitForSlaveTimeout(long waitForSlaveTimeout) {
        this.brokerService.setWaitForSlaveTimeout(waitForSlaveTimeout);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withPassiveSlave(boolean passiveSlave) {
        this.brokerService.setPassiveSlave(passiveSlave);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withIoExceptionHandler(IOExceptionHandler ioExceptionHandler) {
        this.brokerService.setIoExceptionHandler(ioExceptionHandler);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withSchedulerSupport(boolean schedulerSupport) {
        this.brokerService.setSchedulerSupport(schedulerSupport);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withSchedulerDirectoryFile(File schedulerDirectory) {
        this.brokerService.setSchedulerDirectoryFile(schedulerDirectory);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withSchedulerDirectory(String schedulerDirectory) {
        this.brokerService.setSchedulerDirectory(schedulerDirectory);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withSchedulePeriodForDestinationPurge(int schedulePeriodForDestinationPurge) {
        this.brokerService.setSchedulePeriodForDestinationPurge(schedulePeriodForDestinationPurge);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withSchedulePeriodForDiskUsageCheck(int schedulePeriodForDiskUsageCheck) {
        this.brokerService.setSchedulePeriodForDiskUsageCheck(schedulePeriodForDiskUsageCheck);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withDiskUsageCheckRegrowThreshold(int diskUsageCheckRegrowThreshold) {
        this.brokerService.setDiskUsageCheckRegrowThreshold(diskUsageCheckRegrowThreshold);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withMaxPurgedDestinationsPerSweep(int maxPurgedDestinationsPerSweep) {
        this.brokerService.setMaxPurgedDestinationsPerSweep(maxPurgedDestinationsPerSweep);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withBrokerContext(BrokerContext brokerContext) {
        this.brokerService.setBrokerContext(brokerContext);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withBrokerId(String brokerId) {
        this.brokerService.setBrokerId(brokerId);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withUseAuthenticatedPrincipalForJMSXUserID(boolean useAuthenticatedPrincipalForJMSXUserID) {
        this.brokerService.setUseAuthenticatedPrincipalForJMSXUserID(useAuthenticatedPrincipalForJMSXUserID);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withPopulateUserNameInMBeans(boolean value) {
        this.brokerService.setPopulateUserNameInMBeans(value);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withMbeanInvocationTimeout(long mbeanInvocationTimeout) {
        this.brokerService.setMbeanInvocationTimeout(mbeanInvocationTimeout);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withNetworkConnectorStartAsync(boolean networkConnectorStartAsync) {
        this.brokerService.setNetworkConnectorStartAsync(networkConnectorStartAsync);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withAllowTempAutoCreationOnSend(boolean allowTempAutoCreationOnSend) {
        this.brokerService.setAllowTempAutoCreationOnSend(allowTempAutoCreationOnSend);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withOfflineDurableSubscriberTimeout(long offlineDurableSubscriberTimeout) {
        this.brokerService.setOfflineDurableSubscriberTimeout(offlineDurableSubscriberTimeout);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withOfflineDurableSubscriberTaskSchedule(long offlineDurableSubscriberTaskSchedule) {
        this.brokerService.setOfflineDurableSubscriberTaskSchedule(offlineDurableSubscriberTaskSchedule);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withStartAsync(boolean startAsync) {
        this.brokerService.setStartAsync(startAsync);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withRestartAllowed(boolean restartAllowed) {
        this.brokerService.setRestartAllowed(restartAllowed);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withStoreOpenWireVersion(int storeOpenWireVersion) {
        this.brokerService.setStoreOpenWireVersion(storeOpenWireVersion);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withRejectDurableConsumers(boolean rejectDurableConsumers) {
        this.brokerService.setRejectDurableConsumers(rejectDurableConsumers);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withUseVirtualDestSubs(boolean useVirtualDestSubs) {
        this.brokerService.setUseVirtualDestSubs(useVirtualDestSubs);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withUseVirtualDestSubsOnCreation(boolean useVirtualDestSubsOnCreation) {
        this.brokerService.setUseVirtualDestSubsOnCreation(useVirtualDestSubsOnCreation);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withAdjustUsageLimits(boolean adjustUsageLimits) {
        this.brokerService.setAdjustUsageLimits(adjustUsageLimits);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withRollbackOnlyOnAsyncException(boolean rollbackOnlyOnAsyncException) {
        this.brokerService.setRollbackOnlyOnAsyncException(rollbackOnlyOnAsyncException);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withMaxSchedulerRepeatAllowed(int maxSchedulerRepeatAllowed) {
        this.brokerService.setMaxSchedulerRepeatAllowed(maxSchedulerRepeatAllowed);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withCustomSetup(Consumer<BrokerService> consumer) {
        consumer.accept(this.brokerService);
        return this;
    }

    public ActiveMQEmbeddedServiceBuilder withTcpTransport() {
        return this.withTcpTransport(0);
    }

    public ActiveMQEmbeddedServiceBuilder withTcpTransport(int port) {
        return this.withTransport("tcp://0.0.0.0:", port);
    }

    public ActiveMQEmbeddedServiceBuilder withAmqpTransport(int port) {
        return this.withTransport("amqp://0.0.0.0:", port);
    }

    public ActiveMQEmbeddedServiceBuilder withMqttTransport(int port) {
        return this.withTransport("mqtt://0.0.0.0:", port);
    }

    public ActiveMQEmbeddedServiceBuilder withStompTransport(int port, String options) {
        return this.withTransport("stomp://localhost:", port, options);
    }

    public ActiveMQEmbeddedServiceBuilder withTransport(String bindAddress, int port) {
        return this.withTransport(bindAddress, port, null);
    }

    public ActiveMQEmbeddedServiceBuilder withTransport(String bindAddress, int port, String options) {
        try {
            this.brokerService.addConnector(bindAddress + port + (options == null ? "" : options));
        }
        catch (Exception e) {
            Assertions.fail((String)("Unable to add new transport: " + e.getMessage()));
        }
        return this;
    }

    BrokerService brokerService() {
        return this.brokerService;
    }

    public ActiveMQEmbeddedService build() {
        return new ActiveMQEmbeddedService(this.brokerService);
    }

    @Deprecated
    public ActiveMQEmbeddedService buildWithRecycle() {
        return this.build();
    }

    public static ActiveMQEmbeddedServiceBuilder bare() {
        return new ActiveMQEmbeddedServiceBuilder();
    }

    private static String generateDataDirectoryPathForInstance(String name) {
        String dataDirectoryPath = ActiveMQEmbeddedServiceBuilder.class.getResource("/").getFile() + name;
        File dataDirectory = new File(dataDirectoryPath);
        if (dataDirectory.exists()) {
            try {
                FileUtils.deleteDirectory((File)dataDirectory);
            }
            catch (IOException e) {
                LOG.warn("Could not delete the data directory at {}: {} (the error will be ignored, but the tests are likely to fail)", (Object)dataDirectoryPath, (Object)e.getMessage());
            }
        }
        return dataDirectoryPath;
    }

    private static String generateSemiUniqueBrokerName() {
        String semiUniqueName = ActiveMQEmbeddedServiceBuilder.class.getSimpleName() + "-" + BROKER_COUNT.longValue() + "." + ThreadLocalRandom.current().nextInt(1000);
        BROKER_COUNT.increment();
        return semiUniqueName;
    }

    public static ActiveMQEmbeddedServiceBuilder defaultBroker() {
        String semiUniqueName = ActiveMQEmbeddedServiceBuilder.generateSemiUniqueBrokerName();
        return ActiveMQEmbeddedServiceBuilder.defaultBroker(semiUniqueName);
    }

    public static ActiveMQEmbeddedServiceBuilder defaultBroker(String name) {
        String dataDirectoryPath = ActiveMQEmbeddedServiceBuilder.generateDataDirectoryPathForInstance(name);
        return new ActiveMQEmbeddedServiceBuilder().withDeleteAllMessagesOnStartup(true).withBrokerName(name).withAdvisorySupport(false).withUseJmx(false).withDataDirectory(dataDirectoryPath);
    }

    public static ActiveMQEmbeddedServiceBuilder persistentBroker() {
        String semiUniqueName = "persistent" + ActiveMQEmbeddedServiceBuilder.generateSemiUniqueBrokerName();
        BROKER_COUNT.increment();
        return ActiveMQEmbeddedServiceBuilder.persistentBroker(semiUniqueName);
    }

    public static ActiveMQEmbeddedServiceBuilder persistentBroker(String name) {
        String dataDirectoryPath = ActiveMQEmbeddedServiceBuilder.generateDataDirectoryPathForInstance(name);
        return new ActiveMQEmbeddedServiceBuilder().withDeleteAllMessagesOnStartup(true).withBrokerName(name).withAdvisorySupport(false).withUseJmx(false).withPersistent(true).withDataDirectory(dataDirectoryPath);
    }
}

