/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.activemq.services;

import java.io.IOException;
import java.net.URISyntaxException;
import javax.jms.ConnectionFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.DestinationViewMBean;
import org.apache.camel.test.infra.activemq.common.ConnectionFactoryHelper;
import org.apache.camel.test.infra.activemq.services.ActiveMQEmbeddedServiceBuilder;
import org.apache.camel.test.infra.activemq.services.ActiveMQService;
import org.apache.camel.test.infra.messaging.services.ConnectionFactoryAware;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractActiveMQEmbeddedService
implements ActiveMQService,
ConnectionFactoryAware {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractActiveMQEmbeddedService.class);
    private final BrokerService brokerService;

    public AbstractActiveMQEmbeddedService() {
        this(ActiveMQEmbeddedServiceBuilder.defaultBroker().brokerService());
    }

    public AbstractActiveMQEmbeddedService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    public void initialize() {
        LOG.info("Trying to start the embedded ActiveMQ");
        try {
            this.brokerService.start();
            this.brokerService.waitUntilStarted();
            LOG.info("Embedded ActiveMQ running at {}", (Object)this.serviceAddress());
        }
        catch (Exception e) {
            LOG.warn("Unable to start embedded ActiveMQ broker: {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)e.getMessage());
        }
    }

    public void shutdown() {
        LOG.debug("Trying to stop the embedded ActiveMQ");
        try {
            this.brokerService.stop();
            this.brokerService.waitUntilStopped();
            LOG.debug("Embedded ActiveMQ stopped");
        }
        catch (Exception e) {
            LOG.warn("Error stopping embedded ActiveMQ broker: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public void restart() {
        this.shutdown();
        LOG.info("Trying to start the restart ActiveMQ");
        try {
            this.brokerService.start(true);
            this.brokerService.waitUntilStarted();
            LOG.info("Embedded ActiveMQ running at {}", (Object)this.serviceAddress());
        }
        catch (Exception e) {
            LOG.warn("Unable to start embedded ActiveMQ broker: {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)e.getMessage());
        }
    }

    @Override
    public String userName() {
        return null;
    }

    @Override
    public String password() {
        return null;
    }

    public int getConnectionCount() {
        return ((TransportConnector)this.brokerService.getTransportConnectors().get(0)).getConnections().size();
    }

    public BrokerService getBrokerService() {
        return this.brokerService;
    }

    protected String getBrokerUri(int connector) {
        return AbstractActiveMQEmbeddedService.getBrokerUri(this.brokerService, connector);
    }

    public static String getBrokerUri(BrokerService broker, int connector) {
        try {
            return ((TransportConnector)broker.getTransportConnectors().get(connector)).getPublishableConnectString();
        }
        catch (Exception e) {
            LOG.warn("Unable to get ActiveMQ broker address: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public int getPort() {
        try {
            return ((TransportConnector)this.brokerService.getTransportConnectors().get(0)).getServer().getSocketAddress().getPort();
        }
        catch (IOException | URISyntaxException e) {
            LOG.error("Error getting the port: {}", (Object)e.getMessage());
            throw new RuntimeException("Error getting the port", e);
        }
    }

    public abstract String getVmURL();

    public abstract String getVmURL(boolean var1);

    protected String getVmURL(boolean failoverURL, boolean create) {
        return failoverURL ? String.format("failover:(%s?create=%b)", this.brokerService.getVmConnectorURI().toString(), create) : this.brokerService.getVmConnectorURI().toString() + "?create=" + create;
    }

    public DestinationViewMBean getQueueMBean(String queueName) throws MalformedObjectNameException {
        return this.getDestinationMBean(queueName, false);
    }

    public DestinationViewMBean getDestinationMBean(String destinationName, boolean topic) throws MalformedObjectNameException {
        String domain = "org.apache.activemq";
        String destinationType = topic ? "Topic" : "Queue";
        ObjectName name = new ObjectName(String.format("%s:type=Broker,brokerName=localhost,destinationType=%s,destinationName=%s", domain, destinationType, destinationName));
        return (DestinationViewMBean)this.brokerService.getManagementContext().newProxyInstance(name, DestinationViewMBean.class, true);
    }

    @Deprecated
    public ConnectionFactory createConnectionFactory() {
        return this.createConnectionFactory(null);
    }

    @Deprecated
    public ConnectionFactory createConnectionFactory(Integer maximumRedeliveries) {
        return ConnectionFactoryHelper.createConnectionFactory(this.getVmURL(true), maximumRedeliveries);
    }
}

