/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.artemis.services;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.camel.test.AvailablePortFinder;
import org.apache.camel.test.infra.artemis.common.ArtemisRunException;
import org.apache.camel.test.infra.artemis.services.AbstractArtemisEmbeddedService;

public class ArtemisTCPAllProtocolsInfraService
extends AbstractArtemisEmbeddedService {
    private String brokerURL;
    private int port;

    @Override
    protected Configuration configure(Configuration configuration, int port, int brokerId) {
        this.port = port;
        port = AvailablePortFinder.getNextAvailable();
        this.brokerURL = "tcp://0.0.0.0:" + port;
        configuration.setPersistenceEnabled(false);
        try {
            configuration.addAcceptorConfiguration("in-vm", "vm://" + brokerId);
            configuration.addAcceptorConfiguration("connector", this.brokerURL + "?protocols=CORE,AMQP,HORNETQ,OPENWIRE,MQTT");
            configuration.addConnectorConfiguration("connector", new TransportConfiguration(NettyConnectorFactory.class.getName()));
            configuration.setJournalDirectory("target/data/journal");
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw new ArtemisRunException("vm acceptor cannot be configured", e);
        }
        configuration.addAddressSetting("#", new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.FAIL).setDeadLetterAddress(SimpleString.of((String)"DLQ")).setExpiryAddress(SimpleString.of((String)"ExpiryQueue")));
        return configuration;
    }

    @Override
    public String serviceAddress() {
        return this.brokerURL;
    }

    @Override
    public int brokerPort() {
        return this.port;
    }
}

