/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.artemis.services;

import java.util.concurrent.Future;
import org.apache.camel.test.infra.common.TestUtils;
import org.apache.camel.test.infra.messaging.services.MessagingContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.ImageFromDockerfile;

public class ArtemisContainer
extends GenericContainer<ArtemisContainer>
implements MessagingContainer {
    private static final int DEFAULT_MQTT_PORT = 1883;
    private static final int DEFAULT_AMQP_PORT = 5672;
    private static final int DEFAULT_ADMIN_PORT = 8161;
    private static final int DEFAULT_ACCEPTOR_PORT = 61616;
    private static final String FROM_IMAGE_NAME = "fedora:38";
    private static final String FROM_IMAGE_ARG = "FROMIMAGE";

    public ArtemisContainer() {
        super((Future)((ImageFromDockerfile)new ImageFromDockerfile("localhost/apache-artemis:camel", false).withFileFromClasspath("Dockerfile", "org/apache/camel/test/infra/artemis/services/Dockerfile")).withBuildArg(FROM_IMAGE_ARG, TestUtils.prependHubImageNamePrefixIfNeeded((String)FROM_IMAGE_NAME)));
        this.withExposedPorts(new Integer[]{1883, 5672, 8161, 61616});
        this.waitingFor((WaitStrategy)Wait.forListeningPort());
    }

    public int amqpPort() {
        return this.getMappedPort(5672);
    }

    public String amqpEndpoint() {
        return String.format("amqp://%s:%d", this.getHost(), this.amqpPort());
    }

    public int mqttPort() {
        return this.getMappedPort(1883);
    }

    public String mqttEndpoint() {
        return String.format("tcp://%s:%d", this.getHost(), this.mqttPort());
    }

    public int adminPort() {
        return this.getMappedPort(8161);
    }

    public String adminURL() {
        return String.format("http://%s:%d", this.getHost(), this.adminPort());
    }

    public int defaultAcceptorPort() {
        return this.getMappedPort(61616);
    }

    public String defaultEndpoint() {
        return String.format("tcp://%s:%d", this.getHost(), this.defaultAcceptorPort());
    }

    public int openwirePort() {
        return this.defaultAcceptorPort();
    }

    public String getOpenwireEndpoint() {
        return String.format("tcp://%s:%d", this.getHost(), this.openwirePort());
    }
}

