/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.artemis.services;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.camel.test.infra.artemis.services.AbstractArtemisEmbeddedService;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtemisVMService
extends AbstractArtemisEmbeddedService {
    private static final Logger LOG = LoggerFactory.getLogger(ArtemisVMService.class);
    private String brokerURL;

    @Override
    protected Configuration configure(Configuration configuration, int port, int brokerId) {
        this.brokerURL = "vm://" + brokerId;
        LOG.info("Creating a new Artemis VM-based broker");
        configuration.setPersistenceEnabled(false);
        configuration.setJournalMinFiles(10);
        configuration.setSecurityEnabled(false);
        try {
            configuration.addAcceptorConfiguration("in-vm", "vm://" + brokerId);
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            Assertions.fail((String)"vm acceptor cannot be configured");
        }
        configuration.addAddressSetting("#", new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.FAIL).setAutoDeleteQueues(Boolean.valueOf(false)).setDeadLetterAddress(SimpleString.toSimpleString((String)"DLQ")).setExpiryAddress(SimpleString.toSimpleString((String)"ExpiryQueue")));
        return configuration;
    }

    @Override
    public String serviceAddress() {
        return this.brokerURL;
    }

    @Override
    public int brokerPort() {
        return 0;
    }
}

