/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.artemis.services;

import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.camel.test.infra.common.services.TestService;
import org.apache.camel.test.infra.common.services.TestServiceUtil;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public interface ArtemisService
extends BeforeEachCallback,
AfterEachCallback,
TestService {
    public String serviceAddress();

    public String userName();

    public String password();

    public int brokerPort();

    default public void registerProperties() {
        System.setProperty("artemis.service.address", this.serviceAddress());
        System.setProperty("artemis.external", this.serviceAddress());
        System.setProperty("artemis.username", this.userName());
        System.setProperty("artemis.password", this.password());
    }

    default public void afterEach(ExtensionContext extensionContext) throws Exception {
        TestServiceUtil.tryShutdown((TestService)this, (ExtensionContext)extensionContext);
    }

    default public void beforeEach(ExtensionContext extensionContext) throws Exception {
        TestServiceUtil.tryInitialize((TestService)this, (ExtensionContext)extensionContext);
    }

    public void restart();

    public long countMessages(String var1) throws Exception;

    public QueueQueryResult getQueueQueryResult(String var1) throws Exception;
}

