/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.artemis.services;

import jakarta.jms.ConnectionFactory;
import java.io.File;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.core.server.embedded.EmbeddedActiveMQ;
import org.apache.camel.test.AvailablePortFinder;
import org.apache.camel.test.infra.artemis.common.ConnectionFactoryHelper;
import org.apache.camel.test.infra.artemis.services.ArtemisService;
import org.apache.camel.test.infra.messaging.services.ConnectionFactoryAware;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractArtemisEmbeddedService
implements ArtemisService,
ConnectionFactoryAware {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractArtemisEmbeddedService.class);
    private static final LongAdder BROKER_COUNT = new LongAdder();
    protected final EmbeddedActiveMQ embeddedBrokerService = new EmbeddedActiveMQ();
    private final Configuration artemisConfiguration = new ConfigurationImpl();
    private Consumer<Configuration> customConfigurator;
    private final int port;

    public AbstractArtemisEmbeddedService() {
        this(AvailablePortFinder.getNextAvailable());
    }

    protected AbstractArtemisEmbeddedService(int port) {
        this.port = port;
    }

    private synchronized Configuration configure(int port) {
        int brokerId = this.computeBrokerId();
        this.artemisConfiguration.setSecurityEnabled(false);
        File instanceDir = AbstractArtemisEmbeddedService.createInstance(brokerId);
        this.artemisConfiguration.setBrokerInstance(instanceDir);
        this.artemisConfiguration.setJMXManagementEnabled(false);
        this.artemisConfiguration.setMaxDiskUsage(98);
        Configuration config = this.configure(this.artemisConfiguration, port, brokerId);
        if (this.customConfigurator != null) {
            this.customConfigurator.accept(config);
        }
        return config;
    }

    protected int computeBrokerId() {
        int brokerId = BROKER_COUNT.intValue();
        BROKER_COUNT.increment();
        return brokerId;
    }

    private static File createInstance(int brokerId) {
        String subPath;
        File instanceDir = null;
        File target = new File("target");
        File brokerDir = new File(target, "artemis");
        while ((instanceDir = new File(brokerDir, brokerId + "-" + (subPath = AbstractArtemisEmbeddedService.getRandomSubPath()))).exists()) {
        }
        return instanceDir;
    }

    private static String getRandomSubPath() {
        int size = 12;
        return ThreadLocalRandom.current().ints(97, 122).limit(12L).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    protected abstract Configuration configure(Configuration var1, int var2, int var3);

    public void customConfiguration(Consumer<Configuration> configurator) {
        this.customConfigurator = configurator;
    }

    @Override
    public long countMessages(String queue) throws Exception {
        QueueControl coreQueueControl = (QueueControl)this.embeddedBrokerService.getActiveMQServer().getManagementService().getResource("queue." + queue);
        return coreQueueControl.countMessages();
    }

    @Override
    public String userName() {
        return null;
    }

    @Override
    public String password() {
        return null;
    }

    @Override
    public void restart() {
    }

    public synchronized void initialize() {
        try {
            if (this.embeddedBrokerService.getActiveMQServer() == null || !this.embeddedBrokerService.getActiveMQServer().isStarted()) {
                this.embeddedBrokerService.setConfiguration(this.configure(this.port));
                this.embeddedBrokerService.start();
                this.embeddedBrokerService.getActiveMQServer().waitForActivation(20L, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to start embedded Artemis broker: {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)e.getMessage());
        }
    }

    public void shutdown() {
        try {
            this.embeddedBrokerService.stop();
        }
        catch (Exception e) {
            LOG.warn("Unable to start embedded Artemis broker: {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)e.getMessage());
        }
    }

    public EmbeddedActiveMQ getEmbeddedBrokerService() {
        return this.embeddedBrokerService;
    }

    public ConnectionFactory createConnectionFactory() {
        return ConnectionFactoryHelper.createConnectionFactory(this);
    }

    public ConnectionFactory createConnectionFactory(Integer maximumRedeliveries) {
        return ConnectionFactoryHelper.createConnectionFactory(this, maximumRedeliveries);
    }

    @Override
    public QueueQueryResult getQueueQueryResult(String queueQuery) throws Exception {
        return this.embeddedBrokerService.getActiveMQServer().queueQuery(new SimpleString(queueQuery));
    }
}

