/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.artemis.services;

import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.CoreAddressConfiguration;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.camel.test.infra.artemis.services.AbstractArtemisEmbeddedService;
import org.junit.jupiter.api.Assertions;

public class ArtemisAMQPService
extends AbstractArtemisEmbeddedService {
    private String brokerURL;
    private int amqpPort;

    @Override
    protected Configuration configure(Configuration artemisConfiguration, int port, int brokerId) {
        this.amqpPort = port;
        this.brokerURL = "tcp://0.0.0.0:" + this.amqpPort + "?tcpSendBufferSize=1048576;tcpReceiveBufferSize=1048576;protocols=AMQP;useEpoll=true;amqpCredits=1000;amqpMinCredits=300";
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.FAIL);
        try {
            artemisConfiguration.addAcceptorConfiguration("amqp", this.brokerURL);
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            Assertions.fail((String)"AMQP acceptor cannot be configured");
        }
        artemisConfiguration.setPersistenceEnabled(false);
        artemisConfiguration.addAddressesSetting("#", addressSettings);
        artemisConfiguration.setSecurityEnabled(false);
        artemisConfiguration.setMaxDiskUsage(98);
        CoreAddressConfiguration pingTopicConfig = new CoreAddressConfiguration();
        pingTopicConfig.setName("topic.ping");
        pingTopicConfig.addRoutingType(RoutingType.MULTICAST);
        artemisConfiguration.addAddressConfiguration(pingTopicConfig);
        return artemisConfiguration;
    }

    @Override
    public String serviceAddress() {
        return this.brokerURL;
    }

    @Override
    public int brokerPort() {
        return this.amqpPort;
    }
}

