/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.artemis.services;

import java.util.function.Consumer;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.camel.test.infra.artemis.services.AbstractArtemisEmbeddedService;
import org.apache.camel.test.infra.artemis.services.ArtemisPersistentVMService;
import org.apache.camel.test.infra.artemis.services.ArtemisService;
import org.apache.camel.test.infra.artemis.services.ArtemisVMService;

public class ArtemisEmbeddedServiceBuilder {
    private boolean isPersistent;
    private Consumer<Configuration> customConfigurator;

    public ArtemisEmbeddedServiceBuilder withPersistent(boolean persistent) {
        this.isPersistent = persistent;
        return this;
    }

    public ArtemisEmbeddedServiceBuilder withCustomConfiguration(Consumer<Configuration> customConfigurator) {
        this.customConfigurator = customConfigurator;
        return this;
    }

    public ArtemisService build() {
        AbstractArtemisEmbeddedService artemisService = this.isPersistent ? new ArtemisPersistentVMService() : new ArtemisVMService();
        artemisService.customConfiguration(this.customConfigurator);
        return artemisService;
    }
}

