/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.artemis.services;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.camel.test.infra.artemis.services.AbstractArtemisEmbeddedService;
import org.junit.jupiter.api.Assertions;

public class ArtemisPersistentVMService
extends AbstractArtemisEmbeddedService {
    private String brokerURL;

    @Override
    protected Configuration configure(Configuration configuration, int port, int brokerId) {
        this.brokerURL = "vm://" + brokerId;
        configuration.setPersistenceEnabled(true);
        configuration.setJournalType(JournalType.NIO);
        configuration.setMaxDiskUsage(98);
        try {
            configuration.addAcceptorConfiguration("in-vm", this.brokerURL);
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            Assertions.fail((String)"vm acceptor cannot be configured");
        }
        configuration.addAddressSetting("#", new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.FAIL).setAutoDeleteQueues(Boolean.valueOf(false)).setDeadLetterAddress(SimpleString.toSimpleString((String)"DLQ")).setExpiryAddress(SimpleString.toSimpleString((String)"ExpiryQueue")));
        return configuration;
    }

    @Override
    public String serviceAddress() {
        return this.brokerURL;
    }

    @Override
    public int brokerPort() {
        return 0;
    }
}

