/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.aws2.services;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.camel.test.infra.aws.common.services.AWSService;
import org.apache.camel.test.infra.aws2.services.AWSCloudWatchLocalContainerService;
import org.apache.camel.test.infra.aws2.services.AWSConfigLocalContainerService;
import org.apache.camel.test.infra.aws2.services.AWSDynamodbLocalContainerService;
import org.apache.camel.test.infra.aws2.services.AWSEC2LocalContainerService;
import org.apache.camel.test.infra.aws2.services.AWSEventBridgeLocalContainerService;
import org.apache.camel.test.infra.aws2.services.AWSIAMLocalContainerService;
import org.apache.camel.test.infra.aws2.services.AWSKMSLocalContainerService;
import org.apache.camel.test.infra.aws2.services.AWSKinesisLocalContainerService;
import org.apache.camel.test.infra.aws2.services.AWSLambdaLocalContainerService;
import org.apache.camel.test.infra.aws2.services.AWSRemoteService;
import org.apache.camel.test.infra.aws2.services.AWSS3LocalContainerService;
import org.apache.camel.test.infra.aws2.services.AWSSNSLocalContainerService;
import org.apache.camel.test.infra.aws2.services.AWSSQSLocalContainerService;
import org.apache.camel.test.infra.aws2.services.AWSSTSLocalContainerService;
import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;
import org.apache.camel.test.infra.common.services.TestService;

public final class AWSServiceFactory {
    private AWSServiceFactory() {
    }

    public static <T extends AWSService> SimpleTestServiceBuilder<T> builder() {
        return new SimpleTestServiceBuilder("aws");
    }

    private static AWSService createService(Supplier<AWSService> supplier) {
        return (AWSService)AWSServiceFactory.builder().addRemoteMapping(AWSRemoteService::new).addLocalMapping(supplier).withPropertyNameFormat("%s-service.instance.type").build();
    }

    public static AWSService createKinesisService() {
        return (AWSService)AWSServiceFactory.builder().addRemoteMapping(AWSRemoteService::new).addLocalMapping(AWSKinesisLocalContainerService::new).withPropertyNameFormat("%s-service.kinesis.instance.type").build();
    }

    public static AWSService createSQSService() {
        return AWSServiceFactory.createService(AWSSQSLocalContainerService::new);
    }

    public static AWSService createS3Service() {
        return AWSServiceFactory.createService(AWSS3LocalContainerService::new);
    }

    public static AWSService createSNSService() {
        return AWSServiceFactory.createService(AWSSNSLocalContainerService::new);
    }

    public static AWSService createConfigService() {
        return AWSServiceFactory.createService(AWSConfigLocalContainerService::new);
    }

    public static AWSService createCloudWatchService() {
        return AWSServiceFactory.createService(AWSCloudWatchLocalContainerService::new);
    }

    public static AWSService createEC2Service() {
        return AWSServiceFactory.createService(AWSEC2LocalContainerService::new);
    }

    public static AWSService createEventBridgeService() {
        return AWSServiceFactory.createService(AWSEventBridgeLocalContainerService::new);
    }

    public static AWSService createIAMService() {
        return AWSServiceFactory.createService(AWSIAMLocalContainerService::new);
    }

    public static AWSService createKMSService() {
        return AWSServiceFactory.createService(AWSKMSLocalContainerService::new);
    }

    public static AWSService createLambdaService() {
        return AWSServiceFactory.createService(AWSLambdaLocalContainerService::new);
    }

    public static AWSService createSTSService() {
        return AWSServiceFactory.createService(AWSSTSLocalContainerService::new);
    }

    public static AWSService createDynamodbService() {
        return AWSServiceFactory.createService(AWSDynamodbLocalContainerService::new);
    }

    public static AWSService createSingletonDynamoDBService() {
        return SingletonServiceHolder.getInstance(new AWSDynamodbLocalContainerService(), "dynamoDB");
    }

    public static AWSService createSingletonS3Service() {
        return SingletonServiceHolder.getInstance(new AWSS3LocalContainerService(), "s3");
    }

    public static AWSService createSingletonSQSService() {
        return SingletonServiceHolder.getInstance(new AWSSQSLocalContainerService(), "sqs");
    }

    public static AWSService createSingletonEventBridgeService() {
        return SingletonServiceHolder.getInstance(new AWSEventBridgeLocalContainerService(), "eventBridge");
    }

    public static AWSService createSingletonKinesisService() {
        return SingletonServiceHolder.getInstance(new AWSKinesisLocalContainerService(), "kinesis");
    }

    private static class SingletonServiceHolder {
        private static final Map<String, AWSService> INSTANCES_HOLDER = new ConcurrentHashMap<String, AWSService>();

        private SingletonServiceHolder() {
        }

        public static synchronized AWSService getInstance(AWSService service, String name) {
            if (INSTANCES_HOLDER.get(name) == null) {
                SimpleTestServiceBuilder instance = AWSServiceFactory.builder();
                instance.addLocalMapping(() -> new SingletonAWSService(service, name)).addRemoteMapping(AWSRemoteService::new).build();
                INSTANCES_HOLDER.put(name, (AWSService)instance.build());
            }
            return INSTANCES_HOLDER.get(name);
        }
    }

    private static class SingletonAWSService
    extends SingletonService<AWSService>
    implements AWSService {
        public SingletonAWSService(AWSService service, String name) {
            super((TestService)service, name);
        }

        public Properties getConnectionProperties() {
            return ((AWSService)this.getService()).getConnectionProperties();
        }
    }
}

