/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.cassandra.services;

import org.apache.camel.test.infra.cassandra.services.CassandraService;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.CassandraContainer;

public class CassandraLocalContainerService
implements CassandraService,
ContainerService<CassandraContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraLocalContainerService.class);
    private static final String IMAGE_NAME = "cassandra:4.0.6";
    private final CassandraContainer container;

    public CassandraLocalContainerService() {
        this(System.getProperty("cassandra.container", IMAGE_NAME));
    }

    public CassandraLocalContainerService(String imageName) {
        this.container = this.initContainer(imageName);
    }

    public CassandraLocalContainerService(CassandraContainer container) {
        this.container = container;
    }

    protected CassandraContainer initContainer(String imageName) {
        return new CassandraContainer(imageName);
    }

    @Override
    public int getCQL3Port() {
        return this.container.getMappedPort(CassandraContainer.CQL_PORT.intValue());
    }

    @Override
    public String getCassandraHost() {
        return this.container.getHost();
    }

    public void registerProperties() {
        System.setProperty("cassandra.host", this.getCassandraHost());
        System.setProperty("cassandra.cql3.port", String.valueOf(this.getCQL3Port()));
    }

    public void initialize() {
        this.container.start();
        this.registerProperties();
        LOG.info("Cassandra server running at address {}", (Object)this.getCQL3Endpoint());
    }

    public void shutdown() {
        LOG.info("Stopping the Cassandra container");
        this.container.stop();
    }

    public CassandraContainer getContainer() {
        return this.container;
    }
}

