/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.chatscript.services;

import org.apache.camel.test.infra.chatscript.services.ChatScriptService;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;

public class ChatScriptLocalContainerService
implements ChatScriptService,
ContainerService<GenericContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(ChatScriptLocalContainerService.class);
    private static final int SERVICE_PORT = 1024;
    private GenericContainer container;

    public ChatScriptLocalContainerService() {
        String containerName = LocalPropertyResolver.getProperty(ChatScriptLocalContainerService.class, (String)"chatscript.container");
        this.container = new GenericContainer(containerName).withExposedPorts(new Integer[]{1024}).withCreateContainerCmdModifier(createContainerCmd -> createContainerCmd.withTty(Boolean.valueOf(true)));
    }

    public void registerProperties() {
        System.setProperty("chatscript.address", this.serviceAddress());
    }

    public void initialize() {
        LOG.info("Trying to start the ChatScript container");
        this.container.start();
        this.registerProperties();
        LOG.info("ChatScript instance running at {}", (Object)this.serviceAddress());
    }

    public void shutdown() {
        LOG.info("Stopping the ChatScript container");
        this.container.stop();
    }

    public GenericContainer getContainer() {
        return this.container;
    }

    @Override
    public String serviceAddress() {
        return this.container.getHost() + ":" + this.container.getMappedPort(1024);
    }
}

