/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.cli.services;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.apache.camel.test.infra.common.TestUtils;
import org.junit.platform.commons.util.StringUtils;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.MountableFile;

public class CliBuiltContainer
extends GenericContainer<CliBuiltContainer> {
    private static final String CAMEL_REF_ARG = "CAMEL_REF";
    private static final String KEEP_RUNNING_ARG = "KEEP_RUNNING";
    private static final String MOUNT_POINT = "/deployments/data";
    private static final String SSH_PASSWORD_ARG = "SSH_PASSWORD_ARG";
    private static final String FROM_IMAGE_NAME = "fedora:39";
    private static final String FROM_IMAGE_ARG = "FROMIMAGE";
    protected static final int DEV_CONSOLE_PORT = 8080;
    protected static final int SSH_PORT = 22;
    protected static final String TRUSTED_CERT_FOLDER = "/etc/pki/ca-trust/source/anchors";
    private final String sshPassword;

    public CliBuiltContainer(String camelRef, Boolean keepContainerRunning, String dataFolder, String sshPassword, Map<String, String> extraHosts, List<String> trustedCertPaths) {
        super((Future)((ImageFromDockerfile)((ImageFromDockerfile)((ImageFromDockerfile)new ImageFromDockerfile("localhost/camel-cli:" + camelRef + (keepContainerRunning != false ? "-R" : ""), false).withFileFromClasspath("Dockerfile", "org/apache/camel/test/infra/cli/services/Dockerfile")).withFileFromClasspath("entrypoint.sh", "org/apache/camel/test/infra/cli/services/entrypoint.sh")).withFileFromClasspath("99-ssh-jbang.conf", "org/apache/camel/test/infra/cli/services/99-ssh-jbang.conf")).withBuildArg(FROM_IMAGE_ARG, TestUtils.prependHubImageNamePrefixIfNeeded((String)FROM_IMAGE_NAME)).withBuildArg(CAMEL_REF_ARG, camelRef).withBuildArg(KEEP_RUNNING_ARG, String.valueOf(keepContainerRunning)).withBuildArg(SSH_PASSWORD_ARG, sshPassword));
        this.sshPassword = sshPassword;
        if (StringUtils.isNotBlank((String)dataFolder)) {
            this.withFileSystemBind(dataFolder, MOUNT_POINT, BindMode.READ_WRITE);
        }
        if (keepContainerRunning.booleanValue()) {
            this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*keep container running.*", (int)1));
        }
        this.withExposedPorts(new Integer[]{8080, 22});
        if (Objects.nonNull(extraHosts)) {
            extraHosts.forEach((host, ip) -> this.withExtraHost((String)host, (String)ip));
        }
        if (Objects.nonNull(trustedCertPaths)) {
            trustedCertPaths.forEach(t -> {
                Path path = Paths.get(t, new String[0]);
                this.withCopyToContainer((Transferable)MountableFile.forHostPath((Path)path), String.format("%s/%s", TRUSTED_CERT_FOLDER, path.getFileName()));
            });
        }
    }

    public String getMountPoint() {
        return MOUNT_POINT;
    }

    public String getSshPassword() {
        return this.sshPassword;
    }
}

