/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.couchdb.services;

import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.couchdb.services.CouchDbService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class CouchDbLocalContainerService
implements CouchDbService,
ContainerService<GenericContainer> {
    public static final String CONTAINER_IMAGE = "couchdb:2.3.1";
    public static final String CONTAINER_NAME = "couchdb";
    private static final Logger LOG = LoggerFactory.getLogger(CouchDbLocalContainerService.class);
    private final GenericContainer container;

    public CouchDbLocalContainerService() {
        this(System.getProperty("couchdb.container", CONTAINER_IMAGE));
    }

    public CouchDbLocalContainerService(String imageName) {
        this.container = this.initContainer(imageName, CONTAINER_NAME);
    }

    public CouchDbLocalContainerService(GenericContainer container) {
        this.container = container;
    }

    protected GenericContainer initContainer(String imageName, String containerName) {
        return new GenericContainer(DockerImageName.parse((String)imageName)).withNetworkAliases(new String[]{containerName}).withExposedPorts(new Integer[]{5984}).waitingFor((WaitStrategy)Wait.forListeningPort());
    }

    public void registerProperties() {
        System.setProperty("couchdb.service.address", this.getServiceAddress());
        System.setProperty("couchdb.port", String.valueOf(this.port()));
        System.setProperty("couchdb.host", this.host());
    }

    public void initialize() {
        LOG.info("Trying to start the CouchDb container");
        this.container.start();
        this.registerProperties();
        LOG.info("CouchDb instance running at {}", (Object)this.getServiceAddress());
    }

    public void shutdown() {
        LOG.info("Stopping the CouchDb container");
        this.container.stop();
    }

    public GenericContainer getContainer() {
        return this.container;
    }

    @Override
    public String host() {
        return this.container.getHost();
    }

    @Override
    public int port() {
        return this.container.getMappedPort(5984);
    }
}

