/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.etcd3.services;

import io.etcd.jetcd.launcher.EtcdContainer;
import java.util.List;
import java.util.UUID;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.etcd3.services.Etcd3Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class Etcd3LocalContainerService
implements Etcd3Service,
ContainerService<EtcdContainer> {
    public static final String CONTAINER_NAME = "etcd";
    public static final int ETCD_CLIENT_PORT = 2379;
    public static final int ETCD_PEER_PORT = 2380;
    private static final Logger LOG = LoggerFactory.getLogger(Etcd3LocalContainerService.class);
    private final EtcdContainer container;

    public Etcd3LocalContainerService() {
        this(LocalPropertyResolver.getProperty(Etcd3LocalContainerService.class, (String)"etcd.container"));
    }

    public Etcd3LocalContainerService(String imageName) {
        this.container = this.initContainer(imageName, CONTAINER_NAME);
    }

    public Etcd3LocalContainerService(EtcdContainer container) {
        this.container = container;
    }

    public EtcdContainer initContainer(String imageName, String containerName) {
        return (EtcdContainer)((EtcdContainer)((EtcdContainer)((EtcdContainer)new EtcdContainer(imageName, CONTAINER_NAME, List.of(CONTAINER_NAME)).withNetworkAliases(new String[]{containerName})).withClusterToken(UUID.randomUUID().toString()).withExposedPorts(new Integer[]{2379, 2380})).waitingFor((WaitStrategy)Wait.forListeningPort())).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*ready to serve client requests.*", (int)1));
    }

    public void registerProperties() {
        System.setProperty("etcd.service.address", this.getServiceAddress());
    }

    public void initialize() {
        LOG.info("Trying to start the Etcd container");
        this.container.start();
        this.registerProperties();
        LOG.info("Etcd instance running at {}", (Object)this.getServiceAddress());
    }

    public void shutdown() {
        LOG.info("Stopping the Etcd container");
        this.container.stop();
    }

    public EtcdContainer getContainer() {
        return this.container;
    }

    @Override
    public String getServiceAddress() {
        return String.format("http://%s:%d", this.container.getHost(), this.container.getMappedPort(2379));
    }
}

