/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.fhir.services;

import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.fhir.services.FhirService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class FhirLocalContainerService
implements FhirService,
ContainerService<GenericContainer> {
    public static final String CONTAINER_IMAGE = "hapiproject/hapi:v4.2.0";
    public static final String CONTAINER_NAME = "fhir";
    private static final Logger LOG = LoggerFactory.getLogger(FhirLocalContainerService.class);
    private final GenericContainer container;

    public FhirLocalContainerService() {
        this(System.getProperty("fhir.container", CONTAINER_IMAGE));
    }

    public FhirLocalContainerService(String imageName) {
        this.container = this.initContainer(imageName, CONTAINER_NAME);
    }

    public FhirLocalContainerService(GenericContainer container) {
        this.container = container;
    }

    protected GenericContainer initContainer(String imageName, String containerName) {
        return new GenericContainer(imageName).withNetworkAliases(new String[]{containerName}).withExposedPorts(new Integer[]{8080}).withEnv("HAPI_FHIR_VERSION", "R4").withEnv("HAPI_REUSE_CACHED_SEARCH_RESULTS_MILLIS", "-1").waitingFor((WaitStrategy)Wait.forListeningPort()).waitingFor((WaitStrategy)Wait.forHttp((String)"/hapi-fhir-jpaserver/fhir/metadata"));
    }

    public void registerProperties() {
        System.setProperty("fhir.service.base.url", this.getServiceBaseURL());
        System.setProperty("fhir.service.host", this.getHost());
        System.setProperty("fhir.service.port", String.valueOf(this.getPort()));
    }

    public void initialize() {
        LOG.info("Trying to start the FHIR container");
        this.container.start();
        this.registerProperties();
        LOG.info("FHIR instance running at {}", (Object)this.getServiceBaseURL());
    }

    public void shutdown() {
        LOG.info("Stopping the FHIR container");
        this.container.stop();
    }

    public GenericContainer getContainer() {
        return this.container;
    }

    @Override
    public String getServiceBaseURL() {
        return String.format("http://%s:%d/hapi-fhir-jpaserver/fhir", this.container.getHost(), this.container.getMappedPort(8080));
    }

    @Override
    public String getHost() {
        return this.container.getHost();
    }

    @Override
    public Integer getPort() {
        return this.container.getMappedPort(8080);
    }
}

