/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.ftp.services.embedded;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EmbeddedConfiguration {
    static final String DEFAULT_KNOWN_HOSTS = "[localhost]:%d ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAAAgQDdfIWeSV4o68dRrKSzFd/Bk51E65UTmmSrmW0O1ohtzi6HzsDPjXgCtlTt3FqTcfFfI92IlTr4JWqC9UK1QT1ZTeng0MkPQmv68hDANHbt5CpETZHjW5q4OOgWhVvj5IyOC2NZHtKlJBkdsMAa15ouOOJLzBvAvbqOR/yUROsEiQ==";
    private String testDirectory;
    private List<User> users = new ArrayList<User>();
    private User admin;
    private String serverAddress;
    private String keyStore;
    private String keyStorePassword;
    private String keyStoreType;
    private String keyStoreAlgorithm;
    private String knownHosts;
    private String knownHostsPath;
    private String keyPairFile;
    private SecurityConfiguration securityConfiguration;

    public String getTestDirectory() {
        return this.testDirectory;
    }

    void setTestDirectory(String testDirectory) {
        this.testDirectory = testDirectory;
    }

    void addUser(User user) {
        this.users.add(user);
    }

    public List<User> getUsers() {
        return Collections.unmodifiableList(this.users);
    }

    public User getAdmin() {
        return this.admin;
    }

    void setAdmin(User admin) {
        this.admin = admin;
    }

    void setAdmin(String username, String password, User.UserInfo userInfo) {
        this.admin = new User(username, password, userInfo);
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getKeyStoreAlgorithm() {
        return this.keyStoreAlgorithm;
    }

    public void setKeyStoreAlgorithm(String keyStoreAlgorithm) {
        this.keyStoreAlgorithm = keyStoreAlgorithm;
    }

    public String getKnownHosts() {
        return this.knownHosts;
    }

    void setKnownHosts(String knownHosts) {
        this.knownHosts = knownHosts;
    }

    public String getKnownHostsPath() {
        return this.knownHostsPath;
    }

    void setKnownHostsPath(String knownHostsPath) {
        this.knownHostsPath = knownHostsPath;
    }

    public String getKeyPairFile() {
        return this.keyPairFile;
    }

    void setKeyPairFile(String keyPairFile) {
        this.keyPairFile = keyPairFile;
    }

    public SecurityConfiguration getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    public void setSecurityConfiguration(SecurityConfiguration securityConfiguration) {
        this.securityConfiguration = securityConfiguration;
    }

    public static class SecurityConfiguration {
        private final boolean useImplicit;
        private final String authValue;
        private final boolean clientAuth;

        public SecurityConfiguration(boolean useImplicit, String authValue, boolean clientAuth) {
            this.useImplicit = useImplicit;
            this.authValue = authValue;
            this.clientAuth = clientAuth;
        }

        public boolean isUseImplicit() {
            return this.useImplicit;
        }

        public String getAuthValue() {
            return this.authValue;
        }

        public boolean isClientAuth() {
            return this.clientAuth;
        }
    }

    public static class User {
        private final String username;
        private final String password;
        private final UserInfo userInfo;

        public User(String username, String password, UserInfo userInfo) {
            this.username = username;
            this.password = password;
            this.userInfo = userInfo;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public UserInfo getUserInfo() {
            return this.userInfo;
        }

        public static class UserInfo {
            private final String home;
            private final boolean writePermission;

            public UserInfo(String home, boolean writePermission) {
                this.home = home;
                this.writePermission = writePermission;
            }

            public String getHome() {
                return this.home;
            }

            public boolean isWritePermission() {
                return this.writePermission;
            }
        }
    }
}

