/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.ftp.services.embedded;

import java.io.File;
import org.apache.camel.test.infra.ftp.services.embedded.EmbeddedConfiguration;
import org.apache.camel.test.infra.ftp.services.embedded.EmbeddedConfigurationBuilder;
import org.apache.camel.test.infra.ftp.services.embedded.FtpEmbeddedService;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.ssl.SslConfigurationFactory;

public class FtpsEmbeddedService
extends FtpEmbeddedService {
    public FtpsEmbeddedService(EmbeddedConfigurationBuilder embeddedConfigurationBuilder) {
        super(EmbeddedConfigurationBuilder.defaultFtpsConfigurationTemplate());
    }

    public FtpsEmbeddedService(EmbeddedConfiguration.SecurityConfiguration securityConfiguration) {
        super(EmbeddedConfigurationBuilder.defaultFtpsConfigurationTemplate().withSecurityConfiguration(securityConfiguration));
    }

    @Deprecated
    public FtpsEmbeddedService(boolean useImplicit, String authValue, boolean clientAuth) {
        super(EmbeddedConfigurationBuilder.defaultFtpsConfigurationTemplate());
    }

    @Override
    protected FtpServerFactory createFtpServerFactory(EmbeddedConfiguration embeddedConfiguration) {
        FtpServerFactory serverFactory = super.createFtpServerFactory(embeddedConfiguration);
        ListenerFactory listenerFactory = new ListenerFactory(serverFactory.getListener("default"));
        listenerFactory.setPort(this.port);
        listenerFactory.setImplicitSsl(embeddedConfiguration.getSecurityConfiguration().isUseImplicit());
        listenerFactory.setSslConfiguration(this.createSslConfiguration(embeddedConfiguration).createSslConfiguration());
        serverFactory.addListener("default", listenerFactory.createListener());
        return serverFactory;
    }

    private SslConfigurationFactory createSslConfiguration(EmbeddedConfiguration embeddedConfiguration) {
        SslConfigurationFactory sslConfigFactory = new SslConfigurationFactory();
        sslConfigFactory.setSslProtocol(embeddedConfiguration.getSecurityConfiguration().getAuthValue());
        sslConfigFactory.setKeystoreFile(new File(embeddedConfiguration.getKeyStore()));
        sslConfigFactory.setKeystoreType(embeddedConfiguration.getKeyStoreType());
        sslConfigFactory.setKeystoreAlgorithm(embeddedConfiguration.getKeyStoreAlgorithm());
        sslConfigFactory.setKeystorePassword(embeddedConfiguration.getKeyStorePassword());
        sslConfigFactory.setKeyPassword(embeddedConfiguration.getKeyStorePassword());
        sslConfigFactory.setClientAuthentication(embeddedConfiguration.getSecurityConfiguration().getAuthValue());
        if (embeddedConfiguration.getSecurityConfiguration().isClientAuth()) {
            sslConfigFactory.setTruststoreFile(new File(embeddedConfiguration.getKeyStore()));
            sslConfigFactory.setTruststoreType(embeddedConfiguration.getKeyStoreType());
            sslConfigFactory.setTruststoreAlgorithm(embeddedConfiguration.getKeyStoreAlgorithm());
            sslConfigFactory.setTruststorePassword(embeddedConfiguration.getKeyStorePassword());
        }
        return sslConfigFactory;
    }
}

