/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.hbase.services;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.testcontainers.containers.GenericContainer;

public class HBaseContainer
extends GenericContainer {
    private static final Integer CLIENT_PORT = 21818;
    private final HBaseTestingUtility hbaseUtil;

    public HBaseContainer() {
        this.hbaseUtil = new HBaseTestingUtility(HBaseContainer.defaultConf());
    }

    public HBaseContainer(Configuration conf) {
        this.hbaseUtil = new HBaseTestingUtility(conf);
    }

    public void start() {
        try {
            this.hbaseUtil.startMiniCluster(1);
        }
        catch (Exception e) {
            this.logger().warn("couldn't start HBase cluster. Test is not started, but passed!", (Throwable)e);
        }
    }

    public void stop() {
        try {
            this.hbaseUtil.shutdownMiniCluster();
        }
        catch (Exception e) {
            this.logger().warn("Error shutting down the HBase container", (Throwable)e);
        }
    }

    public static Configuration defaultConf() {
        Configuration conf = HBaseConfiguration.create();
        conf.set("test.hbase.zookeeper.property.clientPort", CLIENT_PORT.toString());
        return conf;
    }
}

