/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.hdfs.v2.services;

import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;
import org.apache.camel.test.infra.common.services.TestService;
import org.apache.camel.test.infra.hdfs.v2.services.ContainerLocalHDFSService;
import org.apache.camel.test.infra.hdfs.v2.services.HDFSService;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class HDFSServiceFactory {
    private static SimpleTestServiceBuilder<HDFSService> instance;
    private static HDFSService service;

    private HDFSServiceFactory() {
    }

    public static SimpleTestServiceBuilder<HDFSService> builder() {
        return new SimpleTestServiceBuilder("hdfs");
    }

    public static HDFSService createSingletonService() {
        if (service == null) {
            if (instance == null) {
                instance = HDFSServiceFactory.builder();
                instance.addLocalMapping(() -> new SingletonHDFSService(new ContainerLocalHDFSService(), "hdfs"));
            }
            service = (HDFSService)instance.build();
        }
        return service;
    }

    static class SingletonHDFSService
    extends SingletonService<HDFSService>
    implements HDFSService {
        public SingletonHDFSService(HDFSService service, String name) {
            super((TestService)service, name);
        }

        @Override
        public String getHDFSHost() {
            return ((HDFSService)this.getService()).getHDFSHost();
        }

        @Override
        public int getPort() {
            return ((HDFSService)this.getService()).getPort();
        }

        @Override
        public void beforeAll(ExtensionContext extensionContext) {
            this.addToStore(extensionContext);
        }

        @Override
        public void afterAll(ExtensionContext extensionContext) {
        }
    }
}

