/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.hivemq.services;

import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;
import org.apache.camel.test.infra.common.services.TestService;
import org.apache.camel.test.infra.hivemq.common.HiveMQProperties;
import org.apache.camel.test.infra.hivemq.services.HiveMQService;
import org.apache.camel.test.infra.hivemq.services.LocalHiveMQService;
import org.apache.camel.test.infra.hivemq.services.LocalHiveMQSparkplugTCKService;
import org.apache.camel.test.infra.hivemq.services.RemoteHiveMQService;

public final class HiveMQServiceFactory {
    private HiveMQServiceFactory() {
    }

    public static SimpleTestServiceBuilder<HiveMQService> builder() {
        return new SimpleTestServiceBuilder("hivemq").withPropertyNameFormat("%s.instance.type");
    }

    public static HiveMQService createService() {
        return (HiveMQService)HiveMQServiceFactory.builder().addLocalMapping(LocalHiveMQService::new).addRemoteMapping(RemoteHiveMQService::new).addMapping("hivemq-sparkplug", LocalHiveMQSparkplugTCKService::new).build();
    }

    public static HiveMQService createSingletonService() {
        return SingletonServiceHolder.INSTANCE;
    }

    public static HiveMQService createSingletonService(String mappingName) {
        System.setProperty(HiveMQProperties.HIVEMQ_INSTANCE_TYPE, mappingName);
        return HiveMQServiceFactory.createSingletonService();
    }

    private static class SingletonServiceHolder {
        static final HiveMQService INSTANCE;

        private SingletonServiceHolder() {
        }

        static {
            SimpleTestServiceBuilder<HiveMQService> builder = HiveMQServiceFactory.builder();
            builder.addLocalMapping(() -> new SingletonHiveMQService(new LocalHiveMQService(), "hivemq")).addRemoteMapping(RemoteHiveMQService::new).addMapping("hivemq-sparkplug", () -> new SingletonHiveMQService(new LocalHiveMQSparkplugTCKService(), "hivemq-sparkplug"));
            INSTANCE = (HiveMQService)builder.build();
        }
    }

    static class SingletonHiveMQService
    extends SingletonService<HiveMQService>
    implements HiveMQService {
        public SingletonHiveMQService(HiveMQService service, String name) {
            super((TestService)service, name);
        }

        @Override
        public int getMqttPort() {
            return ((HiveMQService)this.getService()).getMqttPort();
        }

        @Override
        public String getMqttHost() {
            return ((HiveMQService)this.getService()).getMqttHost();
        }

        @Override
        public boolean isRunning() {
            return ((HiveMQService)this.getService()).isRunning();
        }

        @Override
        public String getUserName() {
            return ((HiveMQService)this.getService()).getUserName();
        }

        @Override
        public char[] getUserPassword() {
            return ((HiveMQService)this.getService()).getUserPassword();
        }
    }
}

