/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.jdbc.services;

import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.jdbc.services.JDBCService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.JdbcDatabaseContainer;

public class JDBCLocalContainerService<T extends JdbcDatabaseContainer<T>>
implements JDBCService,
ContainerService<T> {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCLocalContainerService.class);
    private final T container;

    public JDBCLocalContainerService(T container) {
        this.container = container;
    }

    public void registerProperties() {
        System.setProperty("jdbc.connection.url", this.jdbcUrl());
    }

    @Override
    public String jdbcUrl() {
        return this.container.getJdbcUrl();
    }

    public T getContainer() {
        return this.container;
    }

    public void initialize() {
        LOG.info("Trying to start the database container");
        this.container.start();
        this.registerProperties();
        LOG.info("Database instance available via JDBC url {}", (Object)this.jdbcUrl());
    }

    public void shutdown() {
        LOG.info("Stopping the database instance");
        this.container.stop();
    }
}

