/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.jetty.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import javax.servlet.Servlet;
import org.apache.camel.util.KeyValueHolder;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.webapp.WebAppContext;

public class JettyConfiguration {
    public static final String ROOT_CONTEXT_PATH = "/";
    private int port;
    private SSLContext sslContext;
    private String contextPath;
    private AbstractContextHandlerConfiguration<? extends Handler> contextHandlerConfiguration;
    private WebContextConfiguration webContextConfiguration;

    public int getPort() {
        return this.port;
    }

    void setPort(int port) {
        this.port = port;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setContextHandlerConfiguration(AbstractContextHandlerConfiguration<? extends Handler> contextHandlerConfiguration) {
        this.contextHandlerConfiguration = contextHandlerConfiguration;
    }

    public WebContextConfiguration getWebContextConfiguration() {
        return this.webContextConfiguration;
    }

    void setWebContextConfiguration(WebContextConfiguration webContextConfiguration) {
        this.webContextConfiguration = webContextConfiguration;
    }

    public AbstractContextHandlerConfiguration<? extends Handler> getContextHandlerConfiguration() {
        return this.contextHandlerConfiguration;
    }

    public static class HandlerCollectionConfiguration
    extends AbstractContextHandlerConfiguration<HandlerCollection> {
        private final HandlerCollection handlers = new HandlerCollection();

        public HandlerCollectionConfiguration(String contextPath) {
            super(contextPath);
        }

        public void addHandlers(Handler handler) {
            this.handlers.addHandler(handler);
        }

        @Override
        HandlerCollection resolve() {
            return this.handlers;
        }
    }

    public static class ServletHandlerConfiguration
    extends AbstractContextHandlerConfiguration<ServletContextHandler> {
        private String realm;
        private List<KeyValueHolder<String, String>> userInfos = new ArrayList<KeyValueHolder<String, String>>();
        private List<ServletConfiguration<?>> servletConfigurations = new ArrayList();

        public ServletHandlerConfiguration(String contextPath) {
            super(contextPath);
        }

        public void addBasicAuthUser(String username, String password, String realm) {
            this.realm = Objects.requireNonNull(realm);
            this.addBasicAuthUser((KeyValueHolder<String, String>)new KeyValueHolder((Object)username, (Object)password));
        }

        public void addBasicAuthUser(KeyValueHolder<String, String> userInfo) {
            this.userInfos.add(userInfo);
        }

        public List<KeyValueHolder<String, String>> getBasicUsers() {
            return Collections.unmodifiableList(this.userInfos);
        }

        public String getRealm() {
            return this.realm;
        }

        void addServletConfiguration(ServletConfiguration<?> servletConfiguration) {
            this.servletConfigurations.add(servletConfiguration);
        }

        public List<ServletConfiguration<?>> getServletConfigurations() {
            return Collections.unmodifiableList(this.servletConfigurations);
        }

        private SecurityHandler basicAuth(List<KeyValueHolder<String, String>> userInfoList, String realm) {
            HashLoginService l = new HashLoginService();
            UserStore us = new UserStore();
            for (KeyValueHolder<String, String> userInfo : userInfoList) {
                us.addUser((String)userInfo.getKey(), Credential.getCredential((String)((String)userInfo.getValue())), new String[]{"user"});
            }
            l.setName(realm);
            l.setUserStore(us);
            Constraint constraint = new Constraint();
            constraint.setName("BASIC");
            constraint.setRoles(new String[]{"user"});
            constraint.setAuthenticate(true);
            ConstraintMapping cm = new ConstraintMapping();
            cm.setConstraint(constraint);
            cm.setPathSpec("/*");
            ConstraintSecurityHandler csh = new ConstraintSecurityHandler();
            csh.setAuthenticator((Authenticator)new BasicAuthenticator());
            csh.setRealmName("myrealm");
            csh.addConstraintMapping(cm);
            csh.setLoginService((LoginService)l);
            return csh;
        }

        @Override
        ServletContextHandler resolve() {
            ServletContextHandler contextHandler = new ServletContextHandler(1);
            if (!this.userInfos.isEmpty()) {
                contextHandler.setSecurityHandler(this.basicAuth(this.userInfos, this.realm));
            }
            contextHandler.setContextPath(super.getContextPath());
            for (ServletConfiguration<?> servletConfiguration : this.servletConfigurations) {
                contextHandler.addServlet(servletConfiguration.buildServletHolder(), servletConfiguration.getPathSpec());
            }
            if (this.customizer != null) {
                this.customizer.accept(contextHandler);
            }
            return contextHandler;
        }

        public static class ServletConfiguration<T> {
            public static final String ROOT_PATH_SPEC = "/*";
            private final T servlet;
            private final String pathSpec;
            private Map<String, String> initParameters = new HashMap<String, String>();
            private String name;

            public ServletConfiguration(T servlet, String pathSpec) {
                this.servlet = servlet;
                this.pathSpec = pathSpec;
                this.name = null;
            }

            public ServletConfiguration(T servlet, String pathSpec, String name) {
                this.servlet = servlet;
                this.pathSpec = pathSpec;
                this.name = name;
            }

            public T getServlet() {
                return this.servlet;
            }

            public String getPathSpec() {
                return this.pathSpec;
            }

            public void addInitParameter(String param, String value) {
                this.initParameters.put(param, value);
            }

            public Map<String, String> getInitParameters() {
                return Collections.unmodifiableMap(this.initParameters);
            }

            public ServletHolder buildServletHolder() {
                ServletHolder servletHolder = this.resolveServletHolder();
                if (!this.initParameters.isEmpty()) {
                    servletHolder.setInitParameters(this.initParameters);
                }
                return servletHolder;
            }

            public String getName() {
                return this.name;
            }

            private ServletHolder resolveServletHolder() {
                if (this.servlet instanceof ServletHolder) {
                    return (ServletHolder)this.servlet;
                }
                ServletHolder servletHolder = new ServletHolder();
                if (this.name != null) {
                    servletHolder.setName(this.name);
                }
                if (this.servlet instanceof String) {
                    servletHolder.setClassName((String)this.servlet);
                } else if (this.servlet instanceof Servlet) {
                    servletHolder.setServlet((Servlet)this.servlet);
                } else {
                    throw new IllegalArgumentException("Unknown servlet type: " + (Serializable)(this.servlet == null ? "null" : this.servlet.getClass()));
                }
                return servletHolder;
            }
        }
    }

    public static class WebContextConfiguration
    extends AbstractContextHandlerConfiguration<WebAppContext> {
        private String webApp;

        public WebContextConfiguration(String contextPath) {
            super(contextPath);
        }

        public void setWebApp(String webApp) {
            this.webApp = webApp;
        }

        @Override
        public WebAppContext resolve() {
            WebAppContext webAppContext = new WebAppContext(this.webApp, super.getContextPath());
            if (this.customizer != null) {
                this.customizer.accept(webAppContext);
            }
            return webAppContext;
        }
    }

    public static class ContextHandlerConfiguration
    extends AbstractContextHandlerConfiguration<ContextHandler> {
        private final ContextHandler contextHandler;

        public ContextHandlerConfiguration(String contextPath) {
            super(contextPath);
            this.contextHandler = new ContextHandler(contextPath);
        }

        public void setErrorHandler(ErrorHandler errorHandler) {
            this.contextHandler.setErrorHandler(errorHandler);
        }

        public void setHandler(Handler handler) {
            this.contextHandler.setHandler(handler);
        }

        @Override
        ContextHandler resolve() {
            if (this.customizer != null) {
                this.customizer.accept(this.contextHandler);
            }
            return this.contextHandler;
        }
    }

    public static abstract class AbstractContextHandlerConfiguration<T> {
        protected final String contextPath;
        protected Consumer<T> customizer;

        public AbstractContextHandlerConfiguration(String contextPath) {
            this.contextPath = contextPath;
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public void customize(Consumer<T> customizer) {
            this.customizer = customizer;
        }

        abstract T resolve();
    }
}

