/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.jetty.services;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.apache.camel.test.infra.jetty.services.JettyConfiguration;
import org.apache.camel.util.KeyValueHolder;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;

public final class JettyConfigurationBuilder {
    private JettyConfiguration jettyConfiguration = new JettyConfiguration();

    private JettyConfigurationBuilder() {
    }

    public JettyConfigurationBuilder withPort(int port) {
        this.jettyConfiguration.setPort(port);
        return this;
    }

    public JettyConfigurationBuilder withSslContext(SSLContext sslContext) {
        this.jettyConfiguration.setSslContext(sslContext);
        return this;
    }

    public JettyConfigurationBuilder withSslContext(Supplier<SSLContext> contextSupplier) {
        return this.withSslContext(contextSupplier::get);
    }

    public ServletConfigurationBuilder withServletConfiguration() {
        return new ServletConfigurationBuilder(this, this.jettyConfiguration);
    }

    public WebAppContextConfigurationBuilder withWebAppContextConfiguration() {
        return new WebAppContextConfigurationBuilder(this, this.jettyConfiguration);
    }

    public ContextHandlerConfigurationBuilder withContextHandlerConfiguration() {
        return new ContextHandlerConfigurationBuilder(this, this.jettyConfiguration);
    }

    public HandlerContextConfigurationBuilder withHandlerCollectionConfiguration() {
        return new HandlerContextConfigurationBuilder(this, this.jettyConfiguration);
    }

    public JettyConfigurationBuilder withContextPath(String contextPath) {
        this.jettyConfiguration.setContextPath(contextPath);
        return this;
    }

    public JettyConfiguration build() {
        return this.jettyConfiguration;
    }

    public static JettyConfigurationBuilder emptyTemplate() {
        return new JettyConfigurationBuilder();
    }

    public static JettyConfigurationBuilder bareTemplate() {
        return JettyConfigurationBuilder.emptyTemplate().withPort(0).withContextPath("/");
    }

    public static JettyConfiguration bare() {
        return JettyConfigurationBuilder.bareTemplate().build();
    }

    public static class HandlerContextConfigurationBuilder
    implements ConfigurationBuilderDelegate {
        private final JettyConfiguration jettyConfiguration;
        private final JettyConfigurationBuilder jettyConfigurationBuilder;
        private final JettyConfiguration.HandlerCollectionConfiguration handlerCollectionConfiguration;

        public HandlerContextConfigurationBuilder(JettyConfigurationBuilder jettyConfigurationBuilder, JettyConfiguration jettyConfiguration) {
            this.jettyConfiguration = jettyConfiguration;
            this.jettyConfigurationBuilder = jettyConfigurationBuilder;
            this.handlerCollectionConfiguration = new JettyConfiguration.HandlerCollectionConfiguration(jettyConfiguration.getContextPath());
        }

        public HandlerContextConfigurationBuilder addHandlers(Handler handler) {
            this.handlerCollectionConfiguration.addHandlers(handler);
            return this;
        }

        public HandlerContextConfigurationBuilder withCustomizer(Consumer<HandlerCollection> contextHandlerCustomizer) {
            this.handlerCollectionConfiguration.customize(contextHandlerCustomizer);
            return this;
        }

        @Override
        public JettyConfigurationBuilder build() {
            this.jettyConfiguration.setContextHandlerConfiguration(this.handlerCollectionConfiguration);
            return this.jettyConfigurationBuilder;
        }
    }

    public static class ContextHandlerConfigurationBuilder
    implements ConfigurationBuilderDelegate {
        private final JettyConfiguration jettyConfiguration;
        private final JettyConfigurationBuilder jettyConfigurationBuilder;
        private final JettyConfiguration.ContextHandlerConfiguration contextHandlerConfiguration;
        private Consumer<ContextHandler> contextHandlerCustomizer;

        public ContextHandlerConfigurationBuilder(JettyConfigurationBuilder jettyConfigurationBuilder, JettyConfiguration jettyConfiguration) {
            this.jettyConfiguration = jettyConfiguration;
            this.jettyConfigurationBuilder = jettyConfigurationBuilder;
            this.contextHandlerConfiguration = new JettyConfiguration.ContextHandlerConfiguration(jettyConfiguration.getContextPath());
        }

        public ContextHandlerConfigurationBuilder withErrorHandler(ErrorHandler errorHandler) {
            this.contextHandlerConfiguration.setErrorHandler(errorHandler);
            return this;
        }

        public ContextHandlerConfigurationBuilder withHandler(Handler handler) {
            this.contextHandlerConfiguration.setHandler(handler);
            return this;
        }

        public ContextHandlerConfigurationBuilder withCustomizer(Consumer<ContextHandler> contextHandlerCustomizer) {
            this.contextHandlerConfiguration.customize(contextHandlerCustomizer);
            return this;
        }

        @Override
        public JettyConfigurationBuilder build() {
            this.jettyConfiguration.setContextHandlerConfiguration(this.contextHandlerConfiguration);
            return this.jettyConfigurationBuilder;
        }
    }

    public static class WebAppContextConfigurationBuilder
    implements ConfigurationBuilderDelegate {
        private final JettyConfiguration jettyConfiguration;
        private final JettyConfigurationBuilder jettyConfigurationBuilder;
        private final JettyConfiguration.WebContextConfiguration webContextConfiguration;

        public WebAppContextConfigurationBuilder(JettyConfigurationBuilder jettyConfigurationBuilder, JettyConfiguration jettyConfiguration) {
            this.jettyConfigurationBuilder = jettyConfigurationBuilder;
            this.jettyConfiguration = jettyConfiguration;
            this.webContextConfiguration = new JettyConfiguration.WebContextConfiguration(jettyConfiguration.getContextPath());
        }

        public WebAppContextConfigurationBuilder withWebApp(String webApp) {
            this.webContextConfiguration.setWebApp(webApp);
            return this;
        }

        @Override
        public JettyConfigurationBuilder build() {
            this.jettyConfiguration.setContextHandlerConfiguration(this.webContextConfiguration);
            return this.jettyConfigurationBuilder;
        }
    }

    public static class ServletConfigurationBuilder
    implements ConfigurationBuilderDelegate {
        private final JettyConfiguration jettyConfiguration;
        private final JettyConfigurationBuilder jettyConfigurationBuilder;
        private JettyConfiguration.ServletHandlerConfiguration servletHandlerConfiguration;

        public ServletConfigurationBuilder(JettyConfigurationBuilder builder, JettyConfiguration jettyConfiguration) {
            this.jettyConfigurationBuilder = builder;
            this.jettyConfiguration = jettyConfiguration;
            this.servletHandlerConfiguration = new JettyConfiguration.ServletHandlerConfiguration(jettyConfiguration.getContextPath());
        }

        public ServletConfigurationBuilder customize(Consumer<ServletContextHandler> customizer) {
            this.servletHandlerConfiguration.customize(customizer);
            return this;
        }

        public ServletConfigurationBuilder addBasicAuthUser(String username, String password, String realm) {
            this.servletHandlerConfiguration.addBasicAuthUser(username, password, realm);
            return this;
        }

        public ServletConfigurationBuilder addBasicAuthUser(KeyValueHolder<String, String> userInfo) {
            this.servletHandlerConfiguration.addBasicAuthUser(userInfo);
            return this;
        }

        public ServletConfigurationBuilder addServletConfiguration(JettyConfiguration.ServletHandlerConfiguration.ServletConfiguration<?> servletConfiguration) {
            this.servletHandlerConfiguration.addServletConfiguration(servletConfiguration);
            return this;
        }

        @Override
        public JettyConfigurationBuilder build() {
            this.jettyConfiguration.setContextHandlerConfiguration(this.servletHandlerConfiguration);
            return this.jettyConfigurationBuilder;
        }
    }

    private static interface ConfigurationBuilderDelegate {
        public JettyConfigurationBuilder build();
    }
}

