/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.kafka.services;

import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.kafka.services.KafkaService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.utility.DockerImageName;

public class ContainerLocalKafkaService
implements KafkaService,
ContainerService<KafkaContainer> {
    public static final String KAFKA3_IMAGE_NAME = "confluentinc/cp-kafka:7.3.2";
    private static final Logger LOG = LoggerFactory.getLogger(ContainerLocalKafkaService.class);
    private final KafkaContainer kafka;

    public ContainerLocalKafkaService() {
        this.kafka = this.initContainer();
    }

    public ContainerLocalKafkaService(KafkaContainer kafka) {
        this.kafka = kafka;
    }

    protected KafkaContainer initContainer() {
        return new KafkaContainer().withEmbeddedZookeeper();
    }

    @Override
    public String getBootstrapServers() {
        return this.kafka.getBootstrapServers();
    }

    public void registerProperties() {
        System.setProperty("kafka.bootstrap.servers", this.getBootstrapServers());
    }

    public void initialize() {
        this.kafka.start();
        this.registerProperties();
        LOG.info("Kafka bootstrap server running at address {}", (Object)this.kafka.getBootstrapServers());
    }

    public void shutdown() {
        this.kafka.stop();
    }

    public KafkaContainer getContainer() {
        return this.kafka;
    }

    public static ContainerLocalKafkaService kafka2Container() {
        return new ContainerLocalKafkaService();
    }

    public static ContainerLocalKafkaService kafka3Container() {
        KafkaContainer container = new KafkaContainer(DockerImageName.parse((String)KAFKA3_IMAGE_NAME));
        container = container.withEmbeddedZookeeper();
        return new ContainerLocalKafkaService(container);
    }
}

